;----------------------------------------------------------------------------
; J31 BASIC BIOS VTDOS SUPPOT  Ver0.03  by H/konno  2024-07-19
;
;SUMPLE
; J3VT    s邽тɏ풓^
; J3VT S  SIvVŏ풓ƉȂ
; J3VT R  RIvV SIvV̏풓
;----------------------------------------------------------------------------
INCLUDE STDIO.H

code	segment
	assume	cs:code,ds:code,es:code
	org	80h
	argc		db	?		;̃TCY 127bytes
	argv		db	127 dup (?)
	org	100h
;----------------------------------------------------------------------------
start:
	jmp	init
;----------------------------------------------------------------------------
check_id:
	db	'INT intercept 03',00h		; 풓`FbNpID
org_ofs_6Fh:	dw	0			; int 6Fh ItZbgۑp
org_seg_6Fh:	dw	0			; int 6Fh ZOgۑp
org_ofs_10h:	dw	0			; int 10h ItZbgۑp
org_seg_10h:	dw	0			; int 10h ZOgۑp
org_ofs_16h:	dw	0			; int 16h ItZbgۑp
org_seg_16h:	dw	0			; int 16h ZOgۑp
indosf_ofs:	dw	0			; InDOS Flag Offset Address
indosf_seg:	dw	0			; InDOS Flag Segment Address


;----------------------------------------------------------------------------
int10h_entry:				;fBXvC荞

	sti

	cmp	ah,85h			;INT10h AH85h 
	jz	ngclr	         	;vȂ炻̂܂܃^[
	cmp	ah,88h			;INT10h AH88h 
	jz	ngclr	         	;vȂ炻̂܂܃^[
	cmp	ax,0012h         	;AX0012h
	jz	ngclr	         	;vȂ炻̂܂܃^[
	cmp	ax,0000h         	;AX0000h
	jz	ngclr	         	;vȂ炻̂܂܃^[
	jmp	short _RETURN10         ;^[
ngclr:
	mov	al,00	         	;I0iȂj

	iret

_RETURN10:                        	;KINT 10hɔ
	db	0EAh            	;̂Ss͌܂蕶
_OFF10	dw	?               	;FAR JUMPĂ܂
_SEG	dw	?



;----------------------------------------------------------------------------
int16h_entry:				;L[{[h荞

	cmp	ah,0F6h			;INT16h AHF6h 
	jz	ngclr16         	;vȂ炻̂܂܃^[
	cmp	ah,050h			;INT16h AH050h 
	jz	ngclr16         	;vȂ炻̂܂܃^[
	cmp	ah,01Ch			;INT16h AH01Ch 
	jz	ngclr16         	;vȂ炻̂܂܃^[
	cmp	ah,020h			;INT16h AH020h 
	jz	ngclr16         	;vȂ炻̂܂܃^[

	jmp	short _RETURN16         ;^[
ngclr16:
	mov	al,00	         	;I0iȂj
	iret

_RETURN16:                        	;KINT 16hɔ
	db	0EAh            	;̂Ss͌܂蕶
_OFF16	dw	?               	;FAR JUMPĂ܂
_SEG16	dw	?



;----------------------------------------------------------------------------
int6Fh_entry:				;ATOK5荞

	mov	ax,00FFh         	;ʗp iȂj
	iret

_RETURN6F:                        	;KINT 6Fhɔ
	db	0EAh            	;̂Ss͌܂蕶
_OFF6F	dw	?               	;FAR JUMPĂ܂
_SEG6F	dw	?



;============================================================================

init:

	mov	bx,80h          		;t@CASCIIZɂ
	add	bl,[bx]				;̃TCY擾
	inc	bx
	mov	[bx],byte ptr 0 		;I0Dhnull

	mov	bx, offset argv			;̏
SWCHR:	add	bx,1
	cmp byte ptr [bx],'S'
	je	STAYFLG
	cmp byte ptr [bx],'s'
	je	STAYFLG
	cmp byte ptr [bx],'R'
	je	REMOVFLG
	cmp byte ptr [bx],'r'
	je	REMOVFLG
	jmp	short MAIN

STAYFLG:
	mov	al,'S'
	mov	byte ptr [check_id],al
	jmp	short MAIN

REMOVFLG:
	mov	removf,1

MAIN:
	call	get_vector
	
	mov	di,offset check_id
	inc	di			;1炵
chk1:
	mov	si,di
	mov	cx,9h			;10h

	cld
	repe	cmpsb			; 풓`FbN
	jz	remove			; 풓

	cmp	removf,1		;remove flg?
	jne	STAY1			;
	mov	dx,offset MSG11		;풓܂
	jmp	short err10		;


STAY1:
	call	set_vector
	
	mov	ah,34h
	int	21h
	mov	word ptr cs:indosf_ofs,bx
	mov	word ptr cs:indosf_seg,es
	
	mov	ah,09h
	mov	dx,offset stayon
	int	21h
	
	
	mov	es,word ptr cs:[002ch]	; GÃZOg擾
	mov	ax,4900h
	int	21h			; GA
	
	mov	dx,offset init
	mov	cl,4
	shr	dx,cl
	inc	dx			; 풓TCYvZ
	mov	ax,3100h
	int	21h			; 풓I


;----------------------------------------------------------------------------

remove:

	mov	al,byte ptr es:check_id	;'S'
	cmp	al,'S'			;s?
	jne	remov2			;SȊOȂ
	cmp	removf,1		;R opt?
	jne	err10			;RȊOȂȂ


remov2:	call	Reset_Vector
	mov	ax,4900h
	int	21h			; 풓̃R[hGA
	mov	dx,offset MSG02		;'܂
	jnc	END1
	cmp	ax,7
	jne	err9
	mov	dx,offset MSG07		;s 7
	jmp	short END1
err9:	cmp	ax,9
	jne	err10
	mov	dx,offset MSG09		;s 9
	jmp	short END1
err10:	mov	dx,offset MSG10		;܂

END1:
	mov	ah,09h
	int	21h             	;bZ[W\

	mov	ax,4c00h
	int	21h			; I



;----------------------------------------------------------------------------
get_vector:
	mov	ax,3510h
	int	21h			; INT 10h xN^ǂݏo
	mov	word ptr cs:org_ofs_10h,bx
	mov	word ptr cs:org_seg_10h,es
	mov	_SEG,es
	mov	_OFF10,bx         	;荞݃xN^[擾

	mov	ax,3516h
	int	21h			; INT 16h xN^ǂݏo
	mov	word ptr cs:org_ofs_16h,bx
	mov	word ptr cs:org_seg_16h,es
	mov	_SEG16,es
	mov	_OFF16,bx         	;荞݃xN^[擾

	mov	ax,356Fh
	int	21h			; INT 6Fh xN^ǂݏo
	mov	word ptr cs:org_ofs_6Fh,bx
	mov	word ptr cs:org_seg_6Fh,es
	mov	_SEG6F,es
	mov	_OFF6F,bx         	;荞݃xN^[擾
	ret
	
	
;----------------------------------------------------------------------------
	
set_vector:
	cli
	xor	ax,ax
	mov	es,ax
	mov	ax,offset int6Fh_entry	;int6Fh entry point
	mov	word ptr es:[6Fh*04h],ax
	mov	word ptr es:[6Fh*04h+02h],cs
	mov	ax,offset int16h_entry	;int16h entry point
	mov	word ptr es:[16h*04h],ax
	mov	word ptr es:[16h*04h+02h],cs
	mov	ax,offset int10h_entry	;int10h entry point
	mov	word ptr es:[10h*04h],ax
	mov	word ptr es:[10h*04h+02h],cs
	sti
	ret
	
	
;----------------------------------------------------------------------------
	
Reset_Vector:
	mov	si,offset org_ofs_6Fh
	mov	dx,word ptr es:[si]	; 풓vOINT 6FhxN^
	mov	cx,word ptr es:[si+02h]	; 풓vOINT 6FhxN^
	cli				; 荞݋֎~
	push	es
	sub	ax,ax			; ZOg:0000H
	mov	es,ax
	mov	word ptr es:[6Fh*04h],dx
	mov	word ptr es:[6Fh*04h+02h],cx
	pop	es
	sti
	
	mov	si,offset org_ofs_16h
	mov	dx,word ptr es:[si]	; 풓vOINT 16hxN^
	mov	cx,word ptr es:[si+02h]	; 풓vOINT 16hxN^
	cli
	push	es
	sub	ax,ax			; ZOg:0000H
	mov	es,ax
	mov	word ptr es:[16h*04h],dx
	mov	word ptr es:[16h*04h+02h],cx
	pop	es
	sti
	
	mov	si,offset org_ofs_10h
	mov	dx,word ptr es:[si]	; 풓vOINT 10hxN^
	mov	cx,word ptr es:[si+02h]	; 풓vOINT 10hxN^
	cli
	push	es
	sub	ax,ax			; ZOg:0000H
	mov	es,ax
	mov	word ptr es:[10h*04h],dx
	mov	word ptr es:[10h*04h+02h],cx
	pop	es
	sti
	
	ret



;----------------------------------------------------------------------------

removf	db	0
MSG01	db	'풓܂',0Dh,0Ah,24h
MSG02	db	'܂',0Dh,0Ah,24h
MSG07	db	's 7',0Dh,0Ah,24h
MSG09	db	's 9',0Dh,0Ah,24h
MSG10	db	'܂',0Dh,0Ah,24h
MSG11	db	'풓܂',0Dh,0Ah,24h


stayon:
	db	'풓܂',0dh,0ah
	db	' ',0dh,0ah,'$'
stayoff:
	db	'풓',0dh,0ah
	db	' ',0dh,0ah,'$'

code	ends
	end	start
