
;****************************
;	'filer.asm'
;****************************
;	$Revision: 3.7k08h $

	include	vz.inc

IFNDEF NOFILER

;--- Equations ---

;US	equ	TRUE

PX_TTL		equ	1
PX_FILES	equ	36
PX_LFN		equ	78
PX_FREE		equ	24
KEY_SHIFT	equ	00000001b		; ##156.101

DCMP_EXIST	equ	00001b
DCMP_NEW	equ	00010b
DCMP_OLD	equ	00100b
DCMP_LARGE	equ	01000b
DCMP_SMALL	equ	10000b

SORT_NAME	equ	00000001b
SORT_EXT	equ	00000010b
SORT_NEW	equ	00000100b
SORT_OLD	equ	00001000b
SORT_LARGE	equ	00010000b
SORT_SMALL	equ	00100000b
SORT_DIR	equ	01000000b
;SORT_MARK	equ	10000000b

;FM_SPACE	equ	00000001b
;FM_EXEC		equ	00000010b
;FM_DOSBOX	equ	00000100b
;FM_ROTATE	equ	00001000b
;FM_FDCSR	equ	00010000b
;FM_SPCEXT	equ	00100000b
;FM_FBPMK	equ	01000000b

FB_MENU		equ	0001b
FB_TBOX		equ	0010b
FB_EXIST	equ	0100b

FT_ALL		equ	0
FT_BIN		equ	-1
FT_TEXT		equ	1

FLATRCNT	equ	6
FMCMDCNT	equ	4
FATTRCNT	equ	4
NAMEWSIZE	equ	-13
dosscrn_sx	equ	044Ah	;50h=80	; ##156.123

fcmd	macro	cmdnum,label
	db	cmdnum
	dw	cgroup:label
	endm

fmnu	macro	label,mode
	dw	cgroup:label
	db	mode
	endm

;--- External symbols ---

	wseg
	extrn	curdrv		:byte
	extrn	dcmpopt		:byte
	extrn	dirchr		:byte
	extrn	hardware	:byte
	extrn	nm_path		:byte
	extrn	parsef		:byte
	extrn	sortopt		:byte
	extrn	tchdir		:byte
	extrn	flmode		:byte
	extrn	doslen		:byte
	extrn	dossw		:byte
	extrn	flret		:byte
	extrn	fromref		:byte
	extrn	lfnmark		:byte
	extrn	sl_sw		:byte				;##k
	extrn	w_renfrg	:byte				;##k

IFDEF DEBUG_LFN
	extrn	debuglfn	:byte
ENDIF
	extrn	abufsz		:word			; ##k
	extrn	sysmode		:word
	extrn	basemode	:word
	extrn	silent		:word
	extrn	curdir		:word
	extrn	drawfunc	:word
	extrn	dspsw		:word
	extrn	doswd		:word
	extrn	edtsw		:word
	extrn	execcmd		:word
	extrn	extlist		:word
	extrn	farseg		:word
	extrn	fbuf		:word
	extrn	filermnu	:word
	extrn	flcmdp		:word
	extrn	flwork		:word
	extrn	flwork2		:word
	extrn	getextp		:word
	extrn	getnamp		:word
	extrn	hfiles		:word
	extrn	menubit		:word
	extrn	pathbuf		:word
	extrn	pathbuf2	:word
	extrn	pathp		:word
	extrn	pool		:word
	extrn	poolend		:word
	extrn	refloc		:word
	extrn	tmpbuf		:word
	extrn	tmpbuf3		:word
;	extrn	wbuf		:word
	extrn	nbuf		:word
	extrn	menumsgp	:word
	extrn	actwkp		:word
	extrn	retval		:word
	extrn	xbuf		:word
	extrn	dosloc		:word
	extrn	hidden		:word
	extrn	tvzsw		:word
	extrn	dos_version	:word
	extrn	uso_free	:word
	extrn	opt_h		:word
	extrn	nbufsz		:word

	endws

	extrn	addsep		:near
;	extrn	chkline		:near
	extrn	csroff		:near
	extrn	dispframe	:near
	extrn	dosheight	:near
	extrn	doswindow	:near
	extrn	do_mbar		:near
	extrn	drawmbar	:near
	extrn	ems_map		:near
	extrn	fillatr		:near
	extrn	fillc		:near
	extrn	fillset		:near
	extrn	fillspc		:near
	extrn	finddir		:near
	extrn	getatr1		:near
	extrn	getcurdir	:near
	extrn	getcurdir1	:near
	extrn	getcurscrn	:near
	extrn	getkey		:near
	extrn	getloc		:near
	extrn	getscrnsize	:near
	extrn	getwindow	:near
	extrn	histcpy		:near
	extrn	iskanji		:near
	extrn	isslash		:near
	extrn	loadwloc	:near
	extrn	loc		:near
	extrn	locate		:near
	extrn	map_base	:near
	extrn	memmove		:near
	extrn	parsepath1	:near
	extrn	popupmenu	:near
	extrn	printf		:near
	extrn	putc		:near
	extrn	putcw		:near
	extrn	putcurscrn	:near
	extrn	putcurwind	:near
	extrn	puts		:near
	extrn	putmg		:near
	extrn	putspc		:near
	extrn	puts_s		:near
;;;	extrn	readdir_lfn	:near
	extrn	repputc		:near
	extrn	revatr		:near
	extrn	rollwind	:near
	extrn	savewloc	:near
	extrn	schsysmenu	:near
	extrn	setatr		:near
	extrn	setatr1		:near
	extrn	setatr2		:near
	extrn	setdoswindow	:near
	extrn	setenvvar	:near
	extrn	setfnckey	:near
	extrn	setmsgp		:near
	extrn	setwindow	:near
	extrn	shift_key	:near
	extrn	skipchar	:near
	extrn	skipspc		:near
	extrn	skipstr		:near
	extrn	strcmp		:near
	extrn	strcpy		:near
	extrn	strlen		:near
	extrn	strlwr		:near
	extrn	strncpy		:near
	extrn	strskip		:near
	extrn	sysmenu		:near
	extrn	undatr		:near
	extrn	windgets	:near
	extrn	windgetsc	:near
	extrn	windgets1	:near
	extrn	wrdcpy		:near
	extrn	wrdicmp		:near
	extrn	stricmp		:near
	extrn	set_attr	:near
	extrn	isbinary	:near
	extrn	toupper		:near
	extrn	dispask		:near
	extrn	scantbl		:near
	extrn	do_evmac	:near
	extrn	run_evmac	:near
	extrn	isalpha		:near
	extrn	isdigit		:near
	extrn	dispmsg		:near
	extrn	off_silent	:near
	extrn	islower		:near
	extrn	isupper		:near
	extrn	cmdmenu		:near
	extrn	get_mbar	:near
	extrn	sel_number	:near
	extrn	setvzkey	:near
	extrn	strchr		:near
	extrn	maptexts	:near
	extrn	bsave		:near
	extrn	putlabel	:near
	extrn	issilent	:near
	extrn	parbuf		:near
	extrn	spreadexec	:near
	extrn	tstlfn		:near
	extrn	tstlfnr		:near
	extrn	tstlfn2		:near
	extrn	tstlfn3		:near
	extrn	cvtlfn		:near
	extrn	shorten_lfn	:near
	extrn	cvtlfn_path	:near
	extrn	cutpath2	:near
	extrn	ext_module	:near
IFNDEF US
	extrn	fep_mask	:near
	extrn	fep_act		:near
ENDIF

	dseg	; bseg

;--- Local work ---

GDATA flparm,	label,	byte
GDATA fldual,	db,	0		; 0=single, 1=dual
retdir		db	0
fllastcmd	dw	0

GDATA flatrtbl,	db,	<FLATRCNT+1 dup (0)>

GDATA mb_filer,	db,	<1,0,WD,-1>
		dw	0

mn_drive	db	7
drive_c		db	0,0,0
		dw	offset cgroup:draw_drive

mn_vzpath	db	32
		db	0,0,0
		dw	0

mask_all	db	"*.*",0
path_root	db	"\",0
path_parent	db	"..",0

maskbit		dw	0
archive		dw	0
attrbit		db	0
flbinary	db	0
vzpathp		dd	0
GDATA speflag,	db,	0
rotate		db	0
GDATA lastpos,	db,	0
walkmnu		dw	0
isearch		db	0

	endds

	cseg
	assume	ds:cgroup

;--- Constants ---

pf_size		db	"%7lu",0		; ##156.119
IFDEF US
pf_time		db	"%2d-%02d-%02d %2d:%02d%c",0	; ##156.92
pf_time2	db	"%2d-%02d-%04d %2d:%02d%c",0
ELSE
pf_time		db	"%02d-%02d-%02d %2d:%02d",0
pf_time2	db	"%04d-%02d-%02d %2d:%02d",0
ENDIF
pf_files	db	" %d ",0
pf_free		db	" %,lu ",0		; ##156.103

mg_dir		db	"  <DIR>",0		; ##156.119
mg_files	db	"files ",0
mg_free		db	"bytes free ",0
mg_total	db	"bytes total ",0
mg_eod		db	" <End of Dir> ",0
mg_ovf		db	" (Out of Buf) ",0
fl_wd		db	WD			;##k

;--- Filer main ---
;<-- CY :escape
;    NC,AL(flret)
;	 0=Open file
;	 1=exec command
;	-1=sHell

	public	filer
filer	proc
	pushm	<bp,ds>
	movseg	ds,ss
	movseg	es,ss
	push	basemode
;	push	silent
;	test	silent,4
;_ifn z
;	call	off_silent
;_endif
	call	setfnckey
	push	drawfunc
	mov	drawfunc,offset cgroup:redraw_filer
IFNDEF US
	call	fep_mask
ENDIF
	clr	ax
	mov	execcmd,ax
	mov	fllastcmd,ax
	mov	doslen,al
	mov	dossw,al
	call	savewloc
	call	getcurdir
	jmpl	c,filer_x		; ##100.13
	call	getcurscrn
;	call	chkline
	call	initfiler
	mov	bx,offset cgroup:mb_filer
	call	drawmbar
;	mov	si,filermnu
	mov	bp,actwkp
	call	setaccdir
	jc	filer5
	call	setmask
	call	setcurpath
	call	newpath
	tstb	fldual
_ifn z
	push	bp
	mov	bp,[bp].fl_back
	call	setcurpath
  _if c					; ##151.12
	call	resetaccdir
  _endif
	call	newpath
	pop	bp
	call	setcurpath
_endif
	mov	tchdir,FALSE
	call	setflwind
	mov	ax,SYS_FILER
	mov	sysmode,ax
	mov	basemode,ax
	clr	ax
	mov	retval,ax
	mov	getnamp,ax		; vp..-7
	mov	fromref,al		; vp.-9-
	mov	al,EV_FILER
	call	do_evmac
filer1:
	call	bcsron
	clr	ax
	mov	refloc,ax
	mov	dossw,al
	mov	dl,SYS_FILER
	mov	al,CSR_OFF
	call	getkey
	mov	fllastcmd,ax
	call	do_filer
	tstw	execcmd
	jz	filer1
filer5:	pushf
	mov	si,curdir
	call	chpath
;	call	chkline
	tstw	flcmdp
_ifn z
	mov	ax,xbuf
	call	spreadexec
	jc	gdos_c
	mov	execcmd,ax
	jmps	filer7
_endif
	clr	ax
	xchg	ax,execcmd
	tst	ax
	jz	filer8
	cmp	ax,-1
	je	filer8
filer6:
	push	ax
	mov	si,ax
	lodsb
	cmp	al,'['
	pop	ax
_if z
	call	ext_module
	jmps	gdos_c
_endif
	call	spreadexec
	jc	gdos_c
	mov	execcmd,ax
	mov	si,xbuf
	call	dos_go
  _if c
	mov	doslen,cl
  _else
	test	flmode,FM_DOSBOX
    _ifn z
	mov	refloc,0
	mov	cx,DOSLEN-2
	mov	dl,W_DOSBOX
	test	dossw,DOS_BOXTTL
_ifn z
	mov	dl,W_CMDBOX
_endif
	mov	al,GETS_DOSBOX
	call	windgets1
	jcxz	gdos_c
      _if c
gdos_c:	popf
	mov	execcmd,0
	call	setcurpath
	jmp	filer1
      _endif
	or	dossw,DOS_TBOX
	mov	doslen,cl
    _endif
  _endif
filer7:
	mov	al,1
filer8:
	mov	flret,al
	push	ax
	mov	basemode,SYS_SEDIT
	call	nextpool
	call	putcurscrn
	pop	ax
	popf
filer_x:
	call	loadwloc
IFNDEF US
	call	fep_act
ENDIF
	pop	drawfunc
;	pop	silent
;	pushf
;	and	silent,not 4
;	popf
	pop	basemode
	popm	<ds,bp>
	ret
filer	endp


;--- Init filer ---

initfiler proc
	mov	bp,flwork
	tstw	pathp
_ifn z
	mov	fldual,0
	clr	ax
	mov	actwkp,ax
	mov	[bp].fl_which,al
	mov	[bp].fl_mask,al
	tstb	retdir
  _if z
	lea	si,[bp].fl_path
	lea	di,[bp].fl_lastpath
	call	strcpy
  _endif
_else
	tstb	retdir
  _ifn z
	lea	si,[bp].fl_lastpath
	lea	di,[bp].fl_path
	call	strcpy
	tstb	[bp].fl_path
    _if z
	mov	[bp].fl_curf,FALSE
    _endif
	mov	[bp].fl_mask,0
	mov	tchdir,TRUE
	mov	retdir,0
  _endif
_endif
	mov	bx,flwork2
	tstw	actwkp
_if z
	mov	actwkp,bp
_endif
	call	initfl1
	xchg	bx,bp
	call	initfl1
	mov	bx,offset cgroup:mb_filer
	mov	ax,filermnu
	mov	[bx].mb_ttl,ax
	ret
initfl1:
	mov	ax,farseg
	call	ems_map
	mov	[bp].fl_seg,ax
	mov	[bp].fl_back,bx
;	mov	[bp].fl_pooltop,0
	mov	ax,[bp].fl_pooltop
	mov	[bp].fl_poolp,ax
	tstb	[bp].fl_mask
_if z
	call	selwild
_endif
	tstb	[bp].fl_curf
_if z
	mov	si,curdir
	lea	di,[bp].fl_path
	call	strcpy
_endif
	ret
initfiler endp

;--- To new path ---

	public	clrpath
newpath proc
	call	clrpath
	tstw	pathp
	jnz	newpath1
	tstb	tchdir
	jnz	newpath1
	tstw	[bp].fl_files
	jz	newpath1
	mov	bl,[bp].fl_path
	and	bl,1Fh
	msdos	F_IOCTRL,08h
	jc	npath1
	tst	ax
	jnz	npath1
	jmps	newpath1
newpath0:
	mov	[bp].fl_bcsr,0
newpath1:
	call	csroff
newpath2:
	call	initpoolp
	call	readdir
	jmps	npath1
resort:					; ##d9.3
	call	sortdir
redump:
	mov	[bp].fl_home,0
npath1:
	call	tstlfn
_ifn z
	mov	hfiles,1
_endif
	call	initflwind
	call	drawflframe
	call	drawouter
	call	dumpfile
	clc
	ret
clrpath:
	mov	si,pathbuf
	mov	byte ptr [si],0
	ret
newpath endp

;--- Filer command table ---

tb_flcmdsym	db	"LMPSVW+><OEF!H-*/QADRKNUXT"

tb_flcmd:	fcmd	03,do_esc
		fcmd	04,do_cr
		fcmd	05,csr_u
		fcmd	06,csr_d
		fcmd	07,csr_l
		fcmd	08,csr_r
		fcmd	13,do_all		; ##16
		fcmd	15,do_cancel		;
		fcmd	31,csr_rolup
		fcmd	32,csr_roldown
		fcmd	33,csr_rolup2
		fcmd	34,csr_roldown2
		fcmd	35,csr_pageup
		fcmd	36,csr_pagedown
		fcmd	37,csr_pageup
		fcmd	38,csr_pagedown
		fcmd	41,csr_top
		fcmd	42,csr_end
		fcmd	53,do_cr		; ##16
		fcmd	88,csr_ls
		fcmd	89,csr_rs
		fcmd	90,csr_us
		fcmd	91,csr_ds
		fcmd	92,csr_home
		fcmd	93,do_window
		fcmd	94,do_parent		;BS
		db	0

tb_menucmd:
		fmnu	do_drive	,FB_MENU		; #L
		fmnu	do_mask		,FB_MENU		; #M
		fmnu	do_path		,FB_TBOX		; #P
		fmnu	do_sort		,FB_MENU		; #S
		fmnu	do_view		,0			; #V
		fmnu	do_dual		,0			; #W
		fmnu	do_all		,0			; #+
		fmnu	do_tocd		,0			; #>
		fmnu	do_retcd	,0			; #<
		fmnu	do_compare	,FB_MENU		; #O
		fmnu	do_execmnu	,FB_MENU		; #E
		fmnu	do_filemnu	,FB_MENU		; #F
		fmnu	do_exec1	,FB_EXIST		; #!
		fmnu	do_shell	,0			; #H
		fmnu	do_cancel	,0			; #-
		fmnu	do_wild		,0			; #*
		fmnu	do_root		,0			; #/
		fmnu	do_vzpath	,FB_MENU		; #Q
		fmnu	do_attr		,FB_MENU+FB_EXIST	; #A
		fmnu	do_delete	,FB_EXIST		; #D
		fmnu	do_rename	,FB_TBOX+FB_EXIST	; #R
		fmnu	do_makedir	,FB_TBOX		; #K
		fmnu	do_newfile	,FB_TBOX		; #N
		fmnu	newpath1	,0			; #U
		fmnu	redraw_filer	,0			; #X ##t
		fmnu	resort		,0			; #T ##d9.3


;----- Scan filer command -----

		public	scan_flcmd
scan_flcmd	proc
		pushm	<cx,di>
		mov	di,offset cgroup:tb_flcmdsym
		mov	cx,offset tb_flcmd - offset tb_flcmdsym
		call	scantbl
		clc
	_if e
		sub	cl,offset tb_flcmd - offset tb_flcmdsym - 1
		neg	cl
		mov	al,cl
		add	al,CM_FILER3
		stc
	_endif
		popm	<di,cx>
		ret
scan_flcmd	endp

;----- &Fl(path) -----

		public	fx_filer
fx_filer	proc
		push	sysmode
		cmp	sysmode,SYS_SEDIT
	_if e
		pushm	<ds,si>
		mov	ds,[bp].ttops
		call	bsave
		popm	<si,ds>
	_endif
		mov	cx,si
		call	parsepath1
		call	filer
	_if c
		mov	ax,-1
	_endif
		mov	retval,ax
		clr	ax
		mov	execcmd,ax
		pop	ax
		mov	sysmode,ax
		cmp	al,SYS_SEDIT
	_if e
		call	setvzkey
	  _if c
		call	maptexts
	  _endif
	_endif
		ret
fx_filer	endp

;----- &Fm(c) -----

		public	fx_mbar
fx_mbar		proc
		mov	dx,ax
		pushm	<bx,si>
		call	do_mbar
		popm	<si,bx>
	_if c
		mov	al,INVALID
	_endif
		cbw
		mov	retval,ax
		ret
fx_mbar		endp

;----- &Fg(di[,al]) -----

		public	fx_getpool
fx_getpool	proc
		mov	di,si
		mov	al,dl
		call	getpool
		clr	al
		xchg	al,ah
fx_ret:		mov	retval,ax
		call	map_base		; ems map
		ret
fx_getpool	endp

;----- &Fi -----

		public	fx_initpool
fx_initpool	proc
		pushm	<bx,si,bp,ds>
		mov	bp,actwkp
		tst	bp
	_ifn z
		mov	ax,farseg
		call	ems_map
		call	scan_1st
		mov	[bp].fl_poolp,bx
		mov	ax,[bp].fl_selcnt
	_endif
		popm	<ds,bp,si,bx>
		jmps	fx_ret
fx_initpool	endp

;----- &Fn -----

		public	fx_nextpool
fx_nextpool	proc
		pushm	<si,bx>
		call	nextpool
		mov	ax,1
	_if c
		dec	ax
	_endif
		popm	<bx,si>
		jmps	fx_ret
fx_nextpool	endp

;----- Walk on menu bar -----

walk_mbar	proc
		mov	bx,offset cgroup:mb_filer
		mov	cl,lastpos
		clr	ch
		tst	cl
	_ifn s
		cmp	al,CM_R
		je	walk_right
		cmp	al,CM_L
		je	walk_left
	_endif
		clc
		ret
walk_right:
		inc	cx
		cmp	cl,[bx].mb_c
	_if ae
		clr	cx
	_endif
		jmps	walk1
walk_left:
		tst	cx
	_if z
		mov	cl,[bx].mb_c
	_endif
		dec	cx
walk1:
		mov	walkmnu,ax
		mov	lastpos,cl
		call	get_mbar
		stc
		ret
walk_mbar	endp

;----- Is bottom of dir? -----

isbottom	proc
		tstw	[bp].fl_selcnt
	_if z
		mov	ax,[bp].fl_bcsr
		inc	ax
		cmp	ax,[bp].fl_files
	  _if ae
		inc	sp
		inc	sp
	  _endif
	_endif
		ret
isbottom	endp

;--- Do filer ---

;peek do_filer
do_filer proc
	mov	walkmnu,FALSE
	mov	cx,[bp].fl_bcsr
	mov	bx,hfiles
	clr	dh
	xchg	dh,isearch
	tst	al
	jz	do_flkey
	mov	lastpos,INVALID
do_flcmd:
	cmp	al,CM_FILER3
	jb	doflcmd1
	sub	al,CM_FILER3
	clr	dx
doflmenu1:
	cbw
	mov	di,ax
	shl	ax,1
	add	ax,di
	mov	di,offset cgroup:tb_menucmd
	add	di,ax
	mov	cl,cs:[di+2]
doflmenu2:
	mov	ax,walkmnu
	tst	ax
_ifn z
	test	cl,FB_MENU
	jz	doflwalk
_endif
	mov	bx,menumsgp
	test	cl,FB_EXIST
_ifn z
	call	isbottom
_endif
	test	cl,FB_TBOX
_ifn z
	mov	refloc,0
_endif
	push	cx
	call	cs:[di]
	pop	dx
_ifn c
	clr	ax
_endif
	test	dl,FB_MENU
_ifn z
doflwalk:
	call	walk_mbar
	jc	doflkey1
_endif
	call	setflwind
	ret

doflcmd1:
	mov	ah,FALSE
	test	flmode,FM_ROTATE
_ifn z
	mov	ah,TRUE
_endif
	mov	rotate,ah
	mov	si,offset cgroup:tb_flcmd
_repeat
	cmp	al,cs:[si]
	jmpl	e,cs:[si+1]
	add	si,3
	tstb	cs:[si]
_until z
	ret

do_flkey:
;	cmp	dl,':'			; [:] ##152.25
;_if e
;	mov	dx,word ptr [bx].mb_px
;	jmp	do_drive
;_endif
	cmp	dl,'*'			; [*]
	je	do_wild
	cmp	dl,'\'			; [\]
	je	do_root
	cmp	dl,'/'			; [/]
	je	do_root
	cmp	dl,SPC
	jz	do_spc0
	call	shift_key		; ##156.101
	mov	al,dl
	test	ah,KEY_SHIFT
_ifn z
	jmp	do_search
_endif
	test	cs:tvzsw,TSW_NODRV	; Toraji
	jnz	doflkey1		;
	call	isdigit
_if c
	sub	al,'0'+1
    _if s
	push	si
	mov	si,curdir
	lodsb
	pop	si
	call	toupper
	sub	al,'A'
    _endif
	jmp	do_drive1
_endif
doflkey1:
	cbw
	call	toupper
	push	retval
	mov	retval,ax
	mov	al,EV_FILER
	call	do_evmac
_if c
	call	run_evmac
	pop	retval
	jmp	do_flcmd
_endif
	pop	retval
	call	do_mbar
	jc	dofl9
	jmp	doflmenu1
do_filer endp

do_wild proc
	call	selwild
	call	newpath0
dofl9:	ret
do_wild endp

do_root proc
	mov	si,offset cgroup:path_root
	mov	cx,1
	jmp	dopath1
do_root endp

do_parent proc
	mov	dx,offset cgroup:path_parent
	push	ds
	jmps	chgdir1
do_parent endp

;--- Do select command ---

do_spc0:test	flmode,FM_SPACE
	jmpln	z,csr_next
do_spc:
	pushm	<bx,cx>
	call	getpoolp
	jae	dospc9
	push	ds
	mov	ds,dx
	mov	al,[bx].dr_attr
;	test	al,FA_DIREC		; ##156.100
;	jnz	dospcx
; ##d10
	mov	cx,-1
	test	al,FA_SEL
_if z
	neg	cx			; cx = 1
	test	ss:flmode,FM_FBPMK
  _ifn z
	cmp	word ptr [bx].dr_pack,'..'
    _if z
	dec	cx			; cx = 0
	jmps	dospc5
    _endif
  _endif
_endif
	xor	al,FA_SEL
	mov	[bx].dr_attr,al
dospc5:	pop	ds
	add	[bp].fl_selcnt,cx
; ##d10
;	xor	al,FA_SEL
;	mov	[bx].dr_attr,al
;	pop	ds
;	test	al,FA_SEL
;_ifn z
;	inc	[bp].fl_selcnt
;_else
;	dec	[bp].fl_selcnt
;_endif
	call	drawdiskinfo
;	jmps	dospc9
dospc9:	popm	<cx,bx>
	ret
do_cr:
	call	isbottom		;;
	call	set_poolp		;;
	tstw	flcmdp
_if z
	call	check_dir
	jc	docr9
_endif
	push	ds
	call	scan_1st
	tstw	[bp].fl_selcnt
_if z
	test	[bx].dr_attr,FA_DIREC
	jnz	chgdir
_else
	test	ss:flmode,FM_SPCEXT
	jz	docr1
_endif
	tstw	ss:flcmdp
_if z
	call	isspecext
_endif
docr1:	pop	ds
	clc
	jmps	esc8
;docr8:
;	tst	ax
;	jz	do_esc
;	jmps	esc8

chgdir:
	mov	dx,bx
	add	dx,dr_pack
chgdir1:								;
	msdos	F_CHDIR		;3Bh	; Change Current Directory	71
	pop	ds
	jc	docr9			; [gȂ炻̂܂ܖ߂(VTDOS?)
	mov	[bp].fl_home,0	;fl..8  ݍŏi̧فEިڸ؂͉Ԗ?
	lea	si,[bp].fl_path
	push	si
	mov	di,pathbuf
	call	strcpy
	pop	di
	call	getaccdir
	call	newpath1
	call	clrpath
docr9:	ret

do_esc:
	mov	ax,[bp].fl_poolend
	mov	[bp].fl_poolp,ax
	stc
esc8:	inc	sp
	inc	sp
	jmp	filer5

;--- Move block cursor ---

csr_next:
	cmp	hfiles,5
	jne	csr_ds
csr_rs:
	mov	rotate,FALSE
	call	do_spc
csr_r:	call	chkdual
	inc	cx
	cmp	cx,[bp].fl_files
	jb	fscrl1
	tstb	rotate
        jnz	csr_top
	ret

csr_ls:
	mov	rotate,FALSE
	call	csr_l
	jmp	do_spc
csr_l:
	call	chkdual
	dec	cx
	jns	fscroll
	tstb	rotate
        jnz	csr_end
csr9:	ret

csr_ds:
	mov	rotate,FALSE
	call	do_spc
csr_d:
	add	cx,bx
	cmp	cx,[bp].fl_files
	jb	fscroll
	tstb	rotate
        jz	csr9
        cmp     bl,5
        jne	csr_top
	sub	cx,bx
        mov     ax,cx
        cwd
        div     bx
        mov     cx,dx
        cmp     cx,[bp].fl_files
        jae     csr_top
fscrl1:	jmps    fscroll

csr_us:
	mov	rotate,FALSE
	call	csr_u
	jmp	do_spc

csr_u:
	sub	cx,bx
	jnb	fscroll
	tstb	rotate
        jz	csr9
        cmp     bl,5
        jne	csr_end
csru1:
	add	cx,bx
        cmp	cx,[bp].fl_files
        jb	csru1
	sub	cx,bx
        jmps    fscroll

;--- Move cursor to home/bottom ---

csr_home:
	tstw	[bp].fl_bcsr
_ifn z
;	call	bcsroff
csr_top:
	clr	cx
_else
csr_end:
	mov	cx,[bp].fl_files
	dec	cx
_endif
;	jmps	fscroll

;--- Scroll up/down window ---
;--> CX :new position

fscroll proc
	tstw	[bp].fl_files
	jz	frol9
	call	bcsroff
	call	fsetcsr
fscroll1:
	tst	al
	jz	frol9
	cmp	al,1
	je	frolup
	cmp	al,-1
	je	froldn
	jmp	dumpfile
frolup:
	mov	ah,[bp].fl_wsy
	dec	ah
	push	ax
	push	dx
	call	getwindow
	movhl	ax,ATR_WTXT,1
	call	rollwind
	jmps	frol1
froldn:
	clr	ah
	push	ax
	push	dx
	call	getwindow
	movhl	ax,ATR_WTXT,-1
	call	rollwind
frol1:
	pop	bx
	call	getpoolp1
	pop	dx
	call	dumpline
frol9:	ret
fscroll endp

;--- Roll window ---

csr_rolup:
	mov	al,-1
	jmps	viewroll
csr_roldown:
	mov	al,1
	jmps	viewroll
csr_rolup2:
	mov	al,-2
	jmps	viewroll
csr_roldown2:
	mov	al,2
	jmps	viewroll
csr_pageup:
	call	flpageln
	neg	al
	jmps	viewroll
csr_pagedown:
	call	flpageln
;	jmps	viewroll

viewroll proc
	tstw	[bp].fl_files
	jz	frol9
	cbw
	push	ax
	call	bcsroff
	pop	ax
	imul	bx
	mov	dx,[bp].fl_home
	tst	ax
_if s
	add	cx,ax
  _ifn c
	push	ax
	sub	cx,ax
	mov	ax,cx
	div	bl
	mov	cl,ah
	clr	ch
	pop	ax
  _endif
	add	dx,ax
  _ifn c
	cmp	al,-1
    _if e
	clr	ax
    _endif
	clr	dx
  _endif
_else
	add	cx,ax
  _repeat
	cmp	cx,[bp].fl_files
    _break b
	sub	cx,bx
  _until
	pushm	<ax,dx>
	mov	ax,[bp].fl_tsy
	sub	al,[bp].fl_wsy
	sbb	ah,0
	mul	bx
	mov	bx,ax
	popm	<dx,ax>
	add	dx,ax
	cmp	dx,bx
  _if a
	cmp	al,1
    _if e
	clr	ax
    _endif
	mov	dx,bx
  _endif
_endif
	mov	[bp].fl_bcsr,cx
	mov	[bp].fl_home,dx
	cmp	al,1
_if e
	mov	al,[bp].fl_wsy
	dec	al
	mul	byte ptr hfiles
	add	dx,ax
_endif
	jmp	fscroll1
viewroll endp

flpageln proc
	mov	al,[bp].fl_wsy
	test	edtsw,EDT_PGHALF
_ifn z
	shr	al,1
  _if z
	inc	ax
  _endif
	ret
_endif
	dec	ax
	ret
flpageln endp

;--- Set cursor position ---
;--> CX :new position
;<--
; AL :0=hold, 1=rollup, -1=rolldown, else dump
; DX :display ptr

fsetcsr	proc
	mov	[bp].fl_bcsr,cx
	push	bx
	mov	bx,hfiles
	mov	ax,cx
	cwd
	div	bx
	mov	dx,[bp].fl_home
	cmp	cx,dx
_if b
	push	dx
	mul	bx
	mov	dx,ax
	pop	ax
	sub	ax,cx
	cmp	ax,bx
	mov	al,-1
	jbe	fset8
_else
	push	ax
	mov	ax,dx
	cwd
	div	bx
	pop	dx
	mov	cx,dx
	sub	dx,ax
	mov	al,[bp].fl_wsy
	cbw
	cmp	dx,ax
	mov	dx,ax
	mov	al,0
	jb	fset9
  _if e
	mov	ax,cx
	mul	bx
	mov	dx,ax
	add	[bp].fl_home,bx
	mov	al,1
	jmps	fset9
  _endif
	mov	ax,cx
	inc	ax
	sub	ax,dx
	mul	bx
	mov	dx,ax
_endif
fset2:	mov	al,2
fset8:	mov	[bp].fl_home,dx
fset9:	pop	bx
	ret
fsetcsr	endp


;----- Set home position -----
;--> CX :files

fsethome	proc
		mov	ax,cx
		cwd
		div	bx
		push	ax
		mov	bx,hfiles
		mov	ax,[bp].fl_home
		cwd
		div	bx
		pop	dx
		sub	dx,ax
		mov	al,[bp].fl_wsy
		cbw
		cmp	dx,ax
	_if l
		mov	[bp].fl_home,0
	_endif
		ret
fsethome	endp

;--- Get pool pointer ---
;<--
; DX:BX :pool ptr

	public	getpoolp
getpoolp proc
	mov	bx,[bp].fl_bcsr
getpoolp1:
	mov	ax,type _dir
	mul	bx
	add	ax,[bp].fl_pooltop
	mov	bx,ax
	mov	dx,[bp].fl_seg
	cmp	bx,[bp].fl_poolend
	ret
getpoolp endp

;--- Change drive ---

do_drive proc
	msdos	F_CURDRV
	mov	bx,offset cgroup:mn_drive
	mov	[bx].mn_sel,al
	clr	si
	clr	dx
	call	popupmenu
do_drive1:
_ifn c
	mov	dl,PRS_DRV
	call	setdrive
  _ifn c
	call	newpath0
  _endif
	clc
_endif
	ret
do_drive endp

draw_drive proc
	tst	ah
	jnz	sel_drive
	cmp	byte ptr cs:dos_version,3
_if b
	add	al,'A'
	call	putc
	mov	al,':'
_else
	pushm	<bx,dx>
	mov	bl,al
	inc	bl
	msdos	F_IOCTRL,8
	mov	dx,'()'
_ifn c
	tst	ax
	mov	dx,'=='
  _ifn z
	mov	dx,'[]'
  _endif
_endif
	mov	al,dh
	call	putc
	call	putspc
	mov	al,bl
	add	al,'A'-1
	call	putc
	call	putspc
	mov	al,dl
	popm	<dx,bx>
_endif
	call	putc
	call	putspc
	ret
sel_drive:
	sub	al,'A'
	ret
draw_drive endp

;--- Change mask ---

do_mask	proc
	mov	ax,maskbit
	or	ax,hidden
	or	ax,archive
	mov	menubit,ax
	mov	cl,MNU_FMASK
	call	sysmenu
_ifn c
	mov	dl,al
	call	selmask
	call	newpath0
	clc
_endif
	ret
do_mask	endp

selmask proc
	push	dx
	mov	dl,MNU_FMASK
	call	schsysmenu
	pop	dx
_if c
selwild:
	mov	maskbit,0
	mov	si,offset cgroup:mask_all
	jmp	setmask1
_endif
	mov	di,si
	add	di,type _menu
	push	ax
	call	setmsgp
	pop	ax
	mov	cl,dl
	mov	dx,1
	shl	dx,cl
	lodsb
	push	ax
	call	skipspc
	mov	cl,al
	pop	ax
	cmp	cl,'.'
	je	selmsk1
	cmp	cl,'*'
_if e
selmsk1:
	mov	maskbit,dx
	jmp	setmask1
_endif
	cmp	cl,'<'
_if e
	cmp	al,'T'
	je	mask_text
	cmp	al,'B'
	je	mask_bin
	cmp	al,'A'
	je	mask_archive
	cmp	al,'H'
	je	mask_hidden
	ret
_endif
	mov	cx,1
	jmps	dopath1

mask_bin:
	mov	al,FT_BIN
	skip2
mask_text:
	mov	al,FT_TEXT
	test	maskbit,dx
_ifn z
	mov	al,FT_ALL
	clr	dx
_endif
	mov	flbinary,al
	mov	maskbit,dx
	mov	si,offset cgroup:mask_all
	jmp	setmask2
mask_hidden:
	xor	hidden,dx
	ret
mask_archive:
	xor	archive,dx
	ret
selmask endp

;--- Input new path ---

	public do_path
do_path	proc
;	mov	refloc,0
;	mov	dx,word ptr [bp].fl_wpx
;	add	dx,0001h
;	mov	refloc,dx
	mov	si,fbuf				; PATHSZ2
;	mov	cx,PATHSZ2
	mov	cx,PATHSZ
	mov	dl,W_PATH
	call	windgets
	jc	dopath9
	jcxz	do_vzpath
dopath1:
	call	parsepath1
	call	setaccdir
	jc	dopath9
	call	setmask
	call	newpath0
dopath9:ret
do_path	endp

do_vzpath proc
	mov	dl,MNU_VZPATH
	call	schsysmenu
	mov	ax,0
	mov	bx,offset cgroup:mn_vzpath
_ifn c
	mov	bx,si
	mov	ax,si
	add	ax,type _menu
_endif
	push	ax
	mov	di,pathbuf
	mov	si,offset cgroup:nm_path
	call	setenvvar
	pop	di
	jnc	dopath9
	push	di
	mov	word ptr vzpathp.@off,si
	mov	word ptr vzpathp.@seg,ax
	mov	al,-1
	call	scanvzpath
	movseg	ds,ss
	mov	[bx].mn_c,cl
	cmp	cl,[bx].mn_sel
_if be
	dec	cl
	mov	[bx].mn_sel,cl
_endif
	mov	[bx].mn_ext,offset cgroup:draw_vzpath
	clr	dx
	pop	si
	call	popupmenu
_ifn c
	call	scanvzpath
	mov	di,ss:pathbuf
	push	di
	call	wrdcpy
	pop	si
	movseg	ds,ss
	inc	cx
	call	dopath1
	clc
_endif
	call	clrpath			; ##d9.3
	ret

draw_vzpath:
	tst	ah
_if z
	push	ax
	inc	ax
	call	putlabel
	call	putspc
	pop	ax
	call	scanvzpath
	call	puts_s
_else
	call	sel_number
_endif
	ret

scanvzpath:
	lds	si,vzpathp
	cbw
	mov	cx,ax
	jcxz	setvp9
_repeat
	call	skipchar
	jc	setvp1
_loop
setvp9:	ret
setvp1:	not	cx
	inc	cx
	ret
do_vzpath endp

;--- Sort option ---

do_sort	proc
	mov	ax,word ptr sortopt
	mov	menubit,ax
	mov	cl,MNU_FSORT	;6
	call	sysmenu
_ifn c
	mov	cl,al	;1-8
	mov	al,1
	shl	al,cl
if TRUE
	xor	sortopt,al
	and	sortopt,al
ELSE
	cmp	al,sortopt
  _if e
	clr	al
  _endif
	mov	sortopt,al
ENDIF
;	call	newpath0
; ##d9.3
  _if z
	call	newpath0
  _else
	call	resort
  _endif
; ##d9.3
	clc
_endif
	ret
do_sort	endp

;--- Change view mode ---		;#V

do_view proc
	xor	hfiles,4
do_view1:
	call	redump
	tstb	fldual
_ifn z
	push	bp
	mov	bp,[bp].fl_back
	call	setcurpath		; ##k250304 3sǉ LFN\
	call	clrpath			; 
	call	newpath1		; ##k
	call	redump
	pop	bp
	call	setcurpath		; ##k250304 4sǉ tLFN\
	call	clrpath			; 
	call	newpath1		; ##k
	call	redump			; ##k t@Cꗗ\
_endif
	ret
do_view endp

;--- Single/dual window ---		#W

do_dual proc
	xor	fldual,1		;00 fldual db 0 ; 0=single, 1=dual
_ifn z					; single?
	mov	bx,[bp].fl_back		;00 fl_back dw ? ;0  back fl pointer
	mov	[bx].fl_which,TRUE	;fl.25  ǂ̳(E)I?
	push	bp
	mov	bp,bx			;2
	call	setcurpath
	call	clrpath
	call	newpath1
	pop	bp			;1
	call	redump			; ##153.36 2t@Cꗗ\
	call	setcurpath
	call	clrpath			; ##k250304 3sǉ 㑋LFN\
	call	newpath1		; ##k
	call	redump			; ##k 1t@Cꗗ\
	jmps	dowind1
_endif
	tstb	[bp].fl_which
_ifn z
	call	dowind1
	mov	[bp].fl_which,FALSE
_endif
	call	redump			; [bp].home,0  by jiji
	ret
do_dual endp

;--- Change window ---		fcmd	93,do_window

do_window proc
	tstb	fldual
	jz	dowind9
dowind1:
	call	setflwind
	call	bcsroff
	mov	bx,[bp].fl_back
	xchg	bx,bp
	mov	actwkp,bp
	call	setflwind
	call	setcurpath
	call	bcsron
chkdu9:
dowind9:ret
do_window endp

chkdual proc
	tstb	fldual
	jz	chkdu9
	cmp	hfiles,5
	je	chkdu9
	pop	ax
	jmp	dowind1
chkdual endp

;--- To current dir ---

do_tocd proc
	tstb	[bp].fl_curf
_ifn z
;	mov	[bp].fl_curf,FALSE
	mov	si,curdir
	lea	di,[bp].fl_lastpath
	call	strcpy
	lea	si,[bp].fl_path
	mov	di,curdir
	push	si
	call	strcpy
	pop	si
	tstb	fldual
  _ifn z
	push	bp
	mov	bp,[bp].fl_back
;	mov	al,TRUE			; ##151.13
;	xchg	[bp].fl_curf,al
;	tst	al
;   _ifn z
;	lea	di,[bp].fl_path
;	call	iscurdir
;   _endif
	call	setflwind
	call	drawpath
	pop	bp
  _endif
	call	setflwind
	call	drawpath
_endif
	ret
do_tocd endp

iscurdir proc				; ##151.13
	mov	si,curdir
	lea	di,[bp].fl_path
	call	strcmp
	mov	al,TRUE
_if e
	dec	al			; FALSE
_endif
	mov	[bp].fl_curf,al
	ret
iscurdir endp

;--- Return to current dir ---

do_retcd proc
	tstb	[bp].fl_curf
_if z
	lea	si,[bp].fl_lastpath
	tstb	[si]
	jnz	retcd1
	ret
_endif
;	mov	[bp].fl_curf,FALSE
	lea	si,[bp].fl_path
	lea	di,[bp].fl_lastpath
	call	strcpy
	mov	si,curdir
retcd1:	lea	di,[bp].fl_path
	call	strcpy
	call	setcurpath
	call	newpath0
	ret
do_retcd endp

;--- Select all ---

do_all	proc
	push	ds
	lds	bx,dword ptr [bp].fl_pooltop
	clr	cx
doall1:	cmp	bx,[bp].fl_poolend
	jae	doall4
	mov	al,[bx].dr_attr
	test	al,FA_DIREC
_if z
	xor	al,FA_SEL
	mov	[bx].dr_attr,al		; ##157.xx
_endif
	test	al,FA_SEL
_ifn z
	inc	cx
_endif
	add	bx,type _dir
	jmp	doall1
doall4:
	pop	ds
	mov	[bp].fl_selcnt,cx
	call	setflwind
	call	dumpfile
	call	drawdiskinfo
	ret
do_all	endp

;----- Cancel all -----

do_cancel	proc
		push	ds
		lds	bx,dword ptr [bp].fl_pooltop
	_repeat
		cmp	bx,[bp].fl_poolend
	  _break ae
		and	[bx].dr_attr,not FA_SEL
		add	bx,type _dir
	_until
		clr	cx
		jmp	doall4
do_cancel	endp

;--- Compare directory ---

do_compare proc
_repeat
	mov	ax,word ptr dcmpopt
	shl	ax,1
	mov	menubit,ax
	mov	cl,MNU_FCOMP	;7
	push	dx
	call	sysmenu
	pop	dx
	jc	docmp9
	tst	al
	jz	docmp2
	mov	cl,al
	mov	al,80h
	rol	al,cl
	xor	dcmpopt,al
_until
docmp8:
	popm	<es,ds>
	call	setflwind
	call	dumpfile
	call	drawdiskinfo
	clc
docmp9:	ret
docmp2:
	tstb	fldual
	jz	docmp9
	mov	[bp].fl_selcnt,0
	mov	cl,dcmpopt
	pushm	<ds,es>
	lds	bx,dword ptr [bp].fl_pooltop
	movseg	es,ds
docmp3:
	cmp	bx,[bp].fl_poolend
	jae	docmp8
	test	[bx].dr_attr,FA_DIREC
	jnz	docmp7
	lea	si,[bx].dr_pack
	pushm	<bx,bp>
	mov	bp,[bp].fl_back
	mov	bx,[bp].fl_pooltop
  _repeat
	cmp	bx,[bp].fl_poolend
    _break ae
	lea	di,[bx].dr_pack
	call	strcmp
	je	docmp6
	add	bx,type _dir
  _until
	popm	<bp,bx>
	test	cl,DCMP_EXIST
	jnz	docmp_sel
docmp_x:and	[bx].dr_attr,not FA_SEL
	jmps	docmp7
docmp_s:test	cl,DCMP_SMALL
	jz	docmp_x
docmp_sel:
	or	[bx].dr_attr,FA_SEL
	inc	[bp].fl_selcnt
docmp7:	add	bx,type _dir
	jmp	docmp3

docmp6:	mov	di,bx
	popm	<bp,bx>
	test	cl,DCMP_NEW+DCMP_OLD+DCMP_LARGE+DCMP_SMALL
	jz	docmp_x
	test	cl,DCMP_NEW+DCMP_OLD
	jz	docmp_l
	ldl	[bx].dr_time
	cmpl	[di].dr_time
	je	docmp_x
	jb	docmp_o
	test	cl,DCMP_NEW
	jz	docmp_x
	jmps	docmp_l
docmp_o:test	cl,DCMP_OLD
	jz	docmp_x
docmp_l:
	test	cl,DCMP_LARGE+DCMP_SMALL
	jz	docmp_sel
	ldl	[bx].dr_size
	cmpl	[di].dr_size
	je	docmp_x
	jb	docmp_s
	test	cl,DCMP_LARGE
	jz	docmp_x
	jmps	docmp_sel
do_compare endp


;--- Execute DOS command ---

do_execmnu proc
	mov	dl,MNU_FEXEC
;	call	isbottom
	test	flmode,FM_EXEC
	jnz	doexec1
	mov	ax,walkmnu
	or	ax,[bp].fl_selcnt
	jnz	doexec1
do_shell:
	dec	execcmd
	ret
do_filemnu:
	mov	dl,MNU_FFILE
doexec1:call	schsysmenu
	jc	doexec_x
	mov	bx,si
	clr	si
	clr	ax
	call	cmdmenu
	jc	doexec_x
	cmp	ah,MCHR_CMD
_if e
	add	sp,4
	mov	refloc,0
	jmp	do_filer
_endif
	cbw
doexec2:
	mov	di,si
	call	strlen
	mov	cx,ax
	mov	al,TAB
  repne	scasb
_if e
	or	dossw,DOS_BOXTTL
	mov	menumsgp,si
	mov	si,di
	call	skipspc
_endif
	mov	execcmd,si
set_poolp:
	mov	ax,[bp].fl_pooltop
	tstw	[bp].fl_selcnt
_if z
	clr	ax
_endif
	mov	[bp].fl_poolp,ax
	ret
doexec_x:
	stc
	ret
do_execmnu endp

do_exec1 proc
;	call	isbottom
	mov	si,bx		; bx=pm
	jmp	doexec2
do_exec1 endp

;----- File Attribute -----

do_attr		proc
;		call	isbottom
;		mov	refloc,0
		push	ds
		call	getpoolp
		mov	ds,dx
		mov	al,[bx].dr_attr
		pop	ds
		test	al,FA_ARCH
	_ifn z
		or	al,1000b
	_endif
		and	al,1111b
	_repeat
		mov	attrbit,al
		cbw
		mov	menubit,ax
		mov	cl,MNU_FATTR
		clr	dx
		call	sysmenu
		jc	doattr9
		cmp	al,FATTRCNT
	  _break e
		mov	cl,al
		mov	al,1
		shl	al,cl
		xor	al,attrbit
	_until
		mov	di,offset cgroup:do_attr1
		call	do_selfiles
		jc	doattr9
		call	newpath1
		clc
doattr9:	ret
do_attr		endp

do_attr1	proc
		push	ds
		call	copy_pack1
		movseg	ds,ss
		mov	cl,attrbit
		test	cl,1000b
	_ifn z
		and	cl,0111b
		or	cl,FA_ARCH
	_endif
		clr	ch
		msdos	F_ATTR,1
		pop	ds
		ret
do_attr1	endp

;----- Delete -----

do_delete	proc
;		call	isbottom
		mov	dl,M_DELETE
		mov	ax,[bp].fl_selcnt
		tst	ax
	_if z
		inc	ax
	_endif
		push	ax
		mov	bx,sp
		call	dispask
		pop	ax
	_if a
		mov	di,offset cgroup:do_delete1
		call	do_selfiles
	  _ifn c
		call	newpath1
	  _endif
	_endif
		ret
do_delete	endp

do_delete1	proc
		push	ds
		call	copy_pack1
		test	[bx].dr_attr,FA_DIREC
		movseg	ds,ss
		mov	ah,F_DELETE
	_ifn z
		mov	ah,F_RMDIR
	_endif
		int	21h
		pop	ds
		ret
do_delete1	endp

;----- Rename -----

do_rename	proc
;		call	isbottom
;		mov	refloc,0
		push	bx
		call	getpoolp
		pop	si
;		jae	doren9
		jmpl ae,doren9
;		test	word ptr cs:tvzsw,TSW_REN_FLG
;		jz	renflg0			; SFNł
		call	tstlfnr			; TSW_REN_FLG
		jnz	lfnren1			;
renflg0:
	call	tstlfn			;
	_ifn z
lfnren1:
		mov	ds,dx
		lea	dx,[bx].dr_pack
		call	cvtlfn
		lea	si,[di].lfn_name
		movseg	ds,es
		mov	di,ss:nbuf		; pr Hn
		mov	cx,es:[di-2]
		push	di
		movseg	es,ss
		call	strncpy
		pop	si
	_else
		xchg	si,bx
		mov	di,nbuf
		mov	ds,dx
		push	di
		movseg	es,ss
		call	copyafile
		pop	si
	_endif
		movseg	ds,ss
;		mov	cx,62			; rename len
;		cmp	word ptr cs:nbufsz,64	; ##151204
;		jbe	len_62		;
		cmp	word ptr cs:nbufsz,160	; ##151204
		mov	cx,158			; rename len
		jae	len_62		;
		mov	cx,word ptr cs:nbufsz	; ##151204
		sub	cx,2			; lfn len
len_62:
		mov	dl,W_RENFILE
		call	windgetsc
		jc	doren9
		jcxz	doren9
		mov	di,si
		call	strskip
		tstb	[si]
		jz	doren9
		mov	dx,si
		mov	ah,F_RENAME
IFDEF DEBUG_LFN
		tstb	cs:debuglfn
		jnz	doren7
ENDIF
;		test	cs:tvzsw,TSW_REN_FLG		; Rf  #151011
;		jz	renflg2				;
		call	tstlfnr			;##k TSW_REN_FLG
		jnz	lfnren3				;
renflg2:
		call	tstlfn				;
	_ifn z
lfnren3:	movhl	ax,71h,F_RENAME		;7156h	; Move a Dir Entry
	_endif
doren7:		int	21h
		jc	doren9
		call	newpath1
;		call	clrpath				; J[\ʒuێ
doren9:		ret
do_rename	endp

copy_pack1	proc
		mov	si,bx
		mov	di,ss:tmpbuf		; TMPSZ 256
		push	di
		movseg	es,ss
		call	copyafile
		pop	dx
		ret
copy_pack1	endp

;----- Make Dir -----

do_makedir	proc
;		mov	refloc,0
		mov	si,nbuf			; PATHSZ2
;		mov	cx,PATHSZ2	;92	; 62	;
		mov	cx,62
		mov	dl,W_MKDIR
		call	windgets
		mov	ah,F_MKDIR		; ah39h Create Sub-Directory
		jmps	makepath
do_makedir	endp

;----- Make New file -----			; #N

do_newfile	proc
;		mov	refloc,0
		lea	ax,[bp].fl_path
		xchg	ax,curdir
		push	ax
		mov	si,fbuf			; PATHSZ2
;		mov	cx,PATHSZ2		; 92?
		mov	cx,PATHSZ
		mov	dl,W_NEW
		call	windgets
		pop	curdir
		movhl	ax,F_ATTR,0
makepath:
		jc	donew9
		jcxz	donew9
makepath1:
		push	ax
		mov	di,pathbuf
		push	di
		push	si
		lea	si,[bp].fl_path
		call	strcpy
		call	addsep
		pop	si
		call	wrdcpy
		pop	dx
		pop	ax
		push	ax
		cmp	ah,F_MKDIR			; ah39h Create Sub-Directory
	_if e
IFDEF DEBUG_LFN
		tstb	cs:debuglfn
		jnz	donew5
ENDIF
;		test	word ptr cs:tvzsw,TSW_REN_FLG	; ##kv4a
;		jz	nolfn4				;
		call	tstlfnr				; TSW_REN_FLG
		jnz	oklfn4				;
nolfn4:
		call	tstlfn
oklfn4:	  _ifn z
		movhl	ax,71h,F_MKDIR	; 39h Create Sub-Directory
	  _endif
donew5:		int	21h
	_else
IFDEF DEBUG_LFN
		tstb	cs:debuglfn
		jnz	donew6
ENDIF
;		test	word ptr cs:tvzsw,TSW_REN_FLG	; ##kv4a
;		jz	nolfn5				;
		call	tstlfnr			; TSW_REN_FLG
		jnz	oklfn5				;
nolfn5:
		call	tstlfn
oklfn5:	  _ifn z
		pushm	<bx,dx,si>
		mov	si,dx
		clr	bx
		clr	cx
		mov	dx,11h
;FILE_CREATE_OPEN	=	0011h	;̧ٵ ݂Ȃꍇ͸ش
		msdos	716Ch		; ASCIZ߽ɂg/ش
		popm	<si,dx,bx>
	  _else
donew6:		int	21h
		jnc	new_x
		clr	cx
		msdos	F_CREATE		; 3Ch   Create a File
	  _endif
	  _ifn c
		mov	bx,ax
		msdos	F_CLOSE
	  _endif
	_endif
		jc	new_x
		call	skipspc
		pop	ax
		jnc	makepath1
		jmp	donew8

new_x:		pop	ax
donew8:		call	newpath1
		call	clrpath		; ##d9.3
donew9:		ret
do_newfile	endp

;----- Do select files -----
;--> DI :calling proc.
;<-- CY :nop

		public	do_selfiles
do_selfiles	proc
		push	ds
		tstw	[bp].fl_selcnt
	_if z
		push	dx
		push	ax
		call	getpoolp
		pop	ax
		jae	doself_x
		mov	ds,dx
		pop	dx
		push	di
		call	di
		pop	di
	_else
		lds	bx,dword ptr [bp].fl_pooltop
	  _repeat
		cmp	bx,[bp].fl_poolend
	    _break ae
  		test	[bx].dr_attr,FA_SEL
	    _ifn z
		push	di
		call	di
		pop	di
	    _endif
		add	bx,type _dir
	  _until
	_endif
		pop	ds
		clc
		ret
doself_x:	pop	dx
		pop	ds
		stc
		ret
do_selfiles	endp

;--- Quick exec for special EXT ---

isspecext proc
	push	es
	lea	si,[bx].dr_pack
	mov	dx,si
	call	skip_ext
	jc	noext
	call	tstlfn
_ifn z
	call	cvtlfn
	movseg	ds,es
	lea	si,[di].lfn_name
	call	skip_extlfn
;	jc	noext
_endif
	mov	di,si
	movseg	es,ds
	movseg	ds,ss
	mov	dl,MNU_FQUICK
	call	schsysmenu
	jc	noext
	mov	cl,[si].mn_c
	clr	ch
	inc	cx
	add	si,type _menu
_repeat
	mov	al,[si]
	pushm	<ax,di>
	call	wrdicmp						;
	popm	<di,ax>
  _if c
	cmp	fllastcmd,CM_CR
    _if e
	call	islower
    _else
	call	isupper
    _endif
	jc	specext
  _endif
	call	strskip
_loop
noext:	pop	es
	ret
specext:
	call	skipchar
	mov	execcmd,si
	pop	es
	pop	ax
	pop	ax
	ret
isspecext endp

;--- Init dump window ---

initflwind proc
;;	call	doswindow			;
;	call	getscrnsize
	call	dosheight
	sub	ch,4
	cmp	byte ptr cs:opt_h,0				; ##k07k
	jz	iwind0
	sub	ch,byte ptr cs:opt_h				; 
iwind0:	movhl	dx,2,1
	mov	ax,[bp].fl_files
	call	tstlfn
	jnz	iwind1
	cmp	hfiles,5
_if e
	mov	cl,5
	div	cl
	tst	ah
  _ifn z
	inc	al
	clr	ah
  _endif
	mov	cl,WD-2					;##K07t 5g
	jmps	iwin5					;
iwind1:							;
	mov	cl,byte ptr doswd			;##k07t0 lfn frame
	sub	cl,2					;
iwin5:	tstb	fldual					;
  _ifn z
	shr	ch,1
	dec	ch
	tstb	[bp].fl_which
    _ifn z
	add	dh,ch
	add	dh,2
    _endif
  _endif
;	mov	cl,WD-2					;##k07t g
_else
	mov	cl,WD/2-2
	tstb	[bp].fl_which
  _ifn z
	mov	dl,WD/2+1
  _endif
_endif
iwind2:	mov	[bp].fl_tsy,ax
	tst	ah
	jnz	iwind3
	cmp	al,ch
	ja	iwind3
	mov	ch,al
iwind3:	mov	word ptr [bp].fl_wpx,dx
	mov	word ptr [bp].fl_wsx,cx
	call	setwindow
	call	initcsrpos
	ret
initflwind endp

	public	setflwind
setflwind proc
	mov	dx,word ptr [bp].fl_wpx
	mov	cx,word ptr [bp].fl_wsx
	call	setwindow
	ret
setflwind endp

;--- Init cursor position ---

initcsrpos proc
	push	es
	push	ds
	mov	si,pathbuf
	tstb	[si]
	jz	ibcsr2
	call	strlen
	pushm	<ax,si>
	lea	si,[bp].fl_path
	call	strlen
	popm	<si,cx>
	cmp	ax,cx
	ja	ibcsr3
	add	si,ax
	mov	al,[si]
	cmp	al,'\'
_ifn z
	cmp	al,'/'
_endif
_if z
	inc	si
_endif
	clr	cx
	les	di,dword ptr [bp].fl_pooltop
	add	di,dr_pack
_repeat
	cmp	di,[bp].fl_poolend
	jae	ibcsr3
	call	stricmp
	je	ibcsr8
	inc	cx
	add	di,type _dir
_until

ibcsr2:
	mov	cx,[bp].fl_bcsr
_ifn cxz
	cmp	cx,[bp].fl_files
	jb	ibcsr8
_endif
	mov	[bp].fl_home,0
	lds	bx,dword ptr [bp].fl_pooltop
	clr	cx
_repeat
	cmp	bx,[bp].fl_poolend
  _break ae
	test	[bx].dr_attr,FA_DIREC
	jz	ibcsr8
	add	bx,type _dir
	inc	cx
_until
ibcsr3:	clr	cx
ibcsr8:	pop	ds
	call	fsetcsr
	pop	es
	ret
initcsrpos endp

;--- Draw window frame ---

drawflframe proc
	mov	al,ATR_WFRM
	call	dispframe
	call	drawpath
	call	getfre						;##k07i
;	call	drawdiskinfo
;	ret
drawflframe endp


;--- Draw disk info. ---

drawdiskinfo proc
	mov	dh,[bp].fl_wsy
	mov	dl,2
	call	locate
	call	fillset
	mov	dx,[bp].fl_selcnt
	mov	cx,dx
	tst	cx
	jnz	drfile1
	mov	dx,[bp].fl_files
	dec	dx
	mov	al,ATR_W1ST		; ##153.47
	tstb	[bp].fl_overflow
	jnz	drfile2
drfile1:mov	al,ATR_WTXT
drfile2:push	dx
	call	setatr
	mov	bx,sp
	mov	si,offset cgroup:pf_files
	call	printf
	inc	sp
	inc	sp
	mov	al,ATR_WFRM
_ifn cxz
	mov	al,ATR_W1ST
_endif
	mov	si,offset cgroup:mg_files
	mov	dl,PX_FILES-PX_FREE
	call	drfile3
	mov	al,ATR_WTXT
	call	setatr
	ldl	[bp].fl_free
_ifn cxz
	call	sumselsize
_endif
	push	dx
	push	ax
	mov	bx,sp
	mov	si,offset cgroup:pf_free
	call	printf
	add	sp,4
_ifn cxz
	mov	al,ATR_W1ST
	mov	si,offset cgroup:mg_total
_else
	mov	al,ATR_WFRM
	mov	si,offset cgroup:mg_free
_endif
	mov	dl,PX_FILES
drfile3:
	call	setatr
	call	putmg
	mov	al,ATR_WFRM
	call	setatr2
	mov	al,GRC_H
	call	fillc
	ret
drawdiskinfo endp

;--- Sum select files size ---
;<-- DX:AX size

sumselsize proc
	clr	ax
	clr	dx
	mov	bx,bp
	tstb	fldual
_ifn z
	mov	bx,[bp].fl_back
_endif
	mov	cx,[bx].fl_clust
	dec	cx
	mov	di,offset cgroup:sumselsize1
	call	do_selfiles
	ret
sumselsize endp

sumselsize1 proc
	mov	di,word ptr [bx].dr_size
	add	di,cx
_ifn c					; ##100.22
	not	cx
	and	di,cx
	not	cx
	add	ax,di
_endif
	adc	dx,word ptr [bx].dr_size+2
	ret
sumselsize1 endp

;--- Draw path name ---

drawpath proc
	call	iscurdir		; ##151.13
	movhl	dx,-1,PX_TTL
	call	locate
	mov	al,ATR_WTXT
	call	setatr
	tstb	[bp].fl_curf
_if z
	call	revatr
_endif
	call	putspc
	lea	si,[bp].fl_path
	call	tstlfn
_ifn z
	pushm	<ds,es,dx,di>
	call	cvtlfn_path		;--> es:di
	push	di
	call	skipstr
	dec	di
	call	addsep
	lea	si,[bp].fl_mask
	call	strcpy
	pop	si
	movseg	ds,es
	call	strlen		;ax:len
	push	dx					;##k07t
	mov	dx,doswd				;
	sub	dx,6					;
;	cmp	ax,WD-6					;
	cmp	ax,dx
	pop	dx					;
  _if a
	lodsb
	call	putc		;'A:'
	lodsb
	call	putc
	mov	al,GRC_TAB
	call	putc
;	mov	dx,WD-6-3				;
	mov	dx,doswd				;
	sub	dx,9					;
	call	cutpath2
  _endif
	call	puts
	popm	<di,dx,es,ds>
	jmps	drawpath7
_endif
	call	puts
	mov	al,dirchr
	cmp	byte ptr [si-2],al
_ifn e
	call	putc
_endif
	lea	si,[bp].fl_mask
	call	puts
drawpath7:
	call	putspc
	call	getloc
	mov	[bp].fl_ttlsx,dl
	mov	al,ATR_WTXT
	call	setatr
	ret
drawpath endp

;--- Draw outer region ---

drawouter proc
	call	doswindow
;	mov	cl,WD			; ##156.123
	mov	cl,byte ptr doswd			; ##k07t
	mov	al,fldual
	mov	ah,[bp].fl_which
	call	tstlfn
	jnz	outer1
	cmp	hfiles,5
_if e
outer1:	tst	al
  _ifn z
	tst	ah
    _if z
	shr	ch,1
    _endif
  _endif
	clr	dl
_else
	tst	al
  _if z
	inc	dh
	dec	ch
	mov	dl,WD/2
	mov	cl,WD/2
	call	putcurwind
	call	dosheight
;	cmp	cs:opt_h,0
;	jz	iwind9
;	sub	ch,cs:opt_h
iwind9:
  _endif
	mov	dl,[bp].fl_wpx
	dec	dl
	mov	cl,WD/2
_endif
	mov	dh,[bp].fl_wpy
	add	dh,[bp].fl_wsy
	inc	dh
	sub	ch,dh
_if g
	call	putcurwind
_endif
	ret
drawouter endp

;--- Dump files ---

dumpfile proc
	tstb	[bp].fl_wsy
_ifn z
	mov	ax,type _dir
	mul	[bp].fl_home
	mov	bx,[bp].fl_pooltop
	add	bx,ax
	clr	dh
  _repeat
	call	dumpline
	inc	dh
	cmp	dh,[bp].fl_wsy
  _while b
_endif
	ret
dumpfile endp

dumpline proc
	clr	dl
	call	locate
dumpl1:
	push	ds
	mov	ds,[bp].fl_seg
	call	set_flatr
	call	fillset
	cmp	bx,[bp].fl_poolend
_if e
	pop	ds
	mov	si,offset cgroup:mg_eod
	mov	al,'-'		; ----
	tstb	[bp].fl_overflow
  _ifn z
	mov	si,offset cgroup:mg_ovf
	mov	al,'*'		; *****
  _endif
	cmp	ss:hfiles,5
  _if e
	call	putmg
	jmps	dumpl5
  _endif
	push	ax
	call	putspc
	pop	ax
	push	ax
	mov	cl,11
	call	repputc
	call	putmg
	pop	ax
	call	repputc
	call	tstlfn
  _ifn z
;	mov	cl,40
	push	dx
	mov	dx,doswd			;##k07t
	sub	dx,40					;
	mov	cl,dl				;##k07t
	pop	dx
	call	repputc
  _endif
	call	putspc
	jmps	dumpl8
_endif
;	cmp	bx,[bp].fl_poolend	; ##156.127
_if b
	test	ss:flmode,FM_FDCSR
  _if z
	test	[bx].dr_attr,FA_SEL
    _ifn z
	call	revatr
    _endif
	call	putspc
  _else
	clr	ah
	call	put_marker
  _endif
	call	dumpname
_endif
	pop	ds
	mov	dl,14			; ##156.119
	call	fillspc
	cmp	ss:hfiles,5
_if e
dumpl5:	mov	al,ATR_WTXT
	call	setatr
	add	bx,type _dir
	call	getloc
	cmp	dl,77
	jae	dumpl9
	mov	dl,16
	call	fillspc
	jmp	dumpl1
_endif
	call	dumpinfo
dumpl6:	call	putspc
	call	tstlfn
_ifn z
	call	dumplfn
_endif
dumpl8:	add	bx,type _dir
dumpl9:	ret
dumpline endp

dumpname proc
	lea	si,[bx].dr_pack
	test	[bx].dr_attr,FA_DIREC
_ifn z
	call	puts
	mov	al,ss:dirchr
	call	putc
	jmps	dmpn9
_endif
_repeat
	lodsb
	tst	al
  _break z
	cmp	al,'.'
  _break z
	call	iskanji
  _if c
	push	dx
	mov	dh,al
	lodsb
	mov	dl,al
	call	putcw
	pop	dx
  _else
	call	putc
  _endif
_until
	push	ax
	mov	dl,9
	call	fillspc
	pop	ax
	tst	al
_ifn z
	call	putc
	call	puts
_endif
dmpn9:	ret
dumpname endp

dumplfn	proc
	pushm	<ax,es>				; ##k
	clr	ax				;
	mov	es,ax				;
	mov	al,byte ptr es:[dosscrn_sx]	; ##156.123
	mov	cs:fl_wd,al			;
	popm	<es,ax>				;

	pushm	<ds,bx,cx,dx>
	mov	ds,[bp].fl_seg
	lea	si,[bx].dr_pack
	test	[bx].dr_attr,FA_DIREC
	mov	dx,FALSE
_ifn z
	mov	dx,TRUE
	cmp	word ptr [bx].dr_pack,'..'
	jz	dmplfn8
;	jnz	_ndmplfn8
;	jmp	dmplfn8
_ndmplfn8:
_endif
	pushm	<es,dx,di>
	mov	dx,si
	call	cvtlfn
	mov	si,di
	movseg	ds,es
	popm	<di,dx,es>
IFDEF US
	call	putspc
ENDIF
	mov	al,SPC
	tstb	[si].lfn_aliasname
_ifn z
;	mov	al,'+'						;##k07f
;	tstb	cs:lfnmark
;  _ifn z
	mov	al,cs:lfnmark
;  _endif
_endif
	call	putc
	add	si,lfn_name
	call	strlen
	mov	cx,ax
	xor	ax,ax
	mov	al,byte ptr cs:fl_wd	;doswd	;##k07t disp lfnlen
;	mov	ax,doswd			;##k07t disp lfnlen
IFDEF US
;	mov	ax,37
	sub	ax,43				;
ELSE
;	mov	ax,38
	sub	ax,42				;
ENDIF
	sub	ax,dx			; dir : ax--,
	test	cs:tvzsw,TSW_AD
_ifn z
	dec	ax
	dec	ax
_endif
	cmp	cx,ax
_if a
	mov	cx,ax
	call	shorten_lfn
_endif
	call	putnc
	tst	dx
_ifn z
	mov	al,ss:dirchr
	call	putc
_endif
	call	getloc
	cmp	dl,78
	jb	dmplfn8
	call	fillset
	mov	cl,byte ptr cs:fl_wd		;##k07t
	sub	cl,dl
	sub	cl,2
	mov	dl,cl
	call	fillspc
;	call	repputc
	jmps	dmpend
dmplfn8:
;	call	fillset
	mov	dl,PX_LFN
;	mov	dl,fl_wd
;	sub 	dl,2
	call	fillspc
dmplfn9:
	push	dx				;
	pushm	<ax,es>
	clr	ax
	mov	es,ax
	mov	cl,byte ptr es:[dosscrn_sx]	; ##156.123
;	mov	fl_wd,al
	popm	<es,ax>
;	mov	cl,byte ptr fl_wd		;##k07t
	sub	cl,80
	jbe	dmped
	call	repputc
dmped:
	pop	dx
	call	locate
	call	fillset
dmpend:
	popm	<dx,cx,bx,ds>
	ret
dumplfn	endp

putnc	proc
	jcxz	putnc9
_repeat
	lodsb
	call	iskanji
  _if c
	dec	cx
	jz	putnc9
	push	dx
	mov	dh,al
	lodsb
	mov	dl,al
	call	putcw
	pop	dx
  _else
	cmp	al,INVALID		; -1
    _if z
	mov	al,GRC_TAB		; 0f8h
    _endif
	call	putc
  _endif
_loop
putnc9:	ret
putnc	endp

dumpinfo proc
	pushm	<dx,es>
	mov	es,[bp].fl_seg
	test	es:[bx].dr_attr,FA_DIREC
_ifn z
	mov	si,offset cgroup:mg_dir
	call	putmg
_else
	push	bx
	ldl	es:[bx].dr_size
	pushm	<dx,ax>
	mov	bx,sp
	mov	si,offset cgroup:pf_size
	call	printf
	add	sp,4
	pop	bx
_endif
IFDEF US
	mov	dl,22			; ##156.119
ELSE
	mov	dl,23
ENDIF
	call	fillspc
	push	bx
IFDEF US				; ##156.92
	mov	si,bx
;	mov	ch,byte ptr syssw+1
;	and	ch,SW_US / 256
;_if z
;	call	putspc
;_endif
	mov	ax,es:[si].dr_time
	mov	dx,ax
	mov	cl,5
	shr	dx,cl
	and	dx,111111b
	rol	ax,cl
	and	ax,11111b
	clr	bx
;	tst	ch
;_ifn z
	mov	bl,'a'
	cmp	al,12
  _if ae
	mov	bl,'p'
  _endif
	tst	al
  _if z
	add	al,12
  _endif
	cmp	al,12
  _if a
	sub	al,12
  _endif
;_endif
	pushm	<bx,dx,ax>
	mov	ax,es:[si].dr_date
	mov	bx,ax
	and	bx,11111b
	mov	dx,ax
	shr	dx,cl
	and	dx,1111b
	shrm	ax,9,cl
	mov	si,offset cgroup:pf_time
	test	cs:tvzsw,TSW_AD
_ifn z
	call	tstlfn
  _ifn z
	mov	si,offset cgroup:pf_time2
	add	ax,1980
	jmps	dmpinf6
  _endif
_endif
	add	al,80
	cmp	al,100
_if ae
	sub	al,100
_endif
dmpinf6:
;	tst	ch
;_ifn z
	xchg	ax,dx
	xchg	bx,dx
;_endif
	pushm	<bx,dx,ax>
	mov	bx,sp
	call	printf
	add	sp,12
ELSE
	mov	ax,es:[bx].dr_time
	mov	dx,ax
	mov	cl,5
	shr	ax,cl
	and	ax,111111b
	push	ax
	rol	dx,cl
	and	dx,11111b
	push	dx
	mov	ax,es:[bx].dr_date
	mov	dx,ax
	and	ax,11111b
	push	ax
	mov	ax,dx
	shr	ax,cl
	and	ax,1111b
	push	ax
	shrm	dx,9,cl
	mov	si,offset cgroup:pf_time
	test	cs:tvzsw,TSW_AD
_ifn z
	call	tstlfn
  _ifn z
	mov	si,offset cgroup:pf_time2
	add	dx,1980
	jmps	dmpinf6
  _endif
_endif
	add	dx,80
	cmp	dx,100
_if ae
	sub	dx,100
_endif
dmpinf6:push	dx
	mov	bx,sp
	call	printf
	add	sp,10
ENDIF
	pop	bx
dmpinf9:popm	<es,dx>
	ret
dumpinfo endp


;----- Set filer attribute ------

set_flatr	proc
		push	bp
		clr	al
		cmp	bx,[bp].fl_poolend
	_if b
		mov	al,[bx].dr_attr
	_endif
		mov	ah,al
		and	ah,FA_DIREC+FA_BINARY
		shlm	al,5,cl
		or	al,ah
		mov	bp,offset cgroup:flatrtbl
		mov	cx,FLATRCNT-1
	_repeat
		shl	al,1
	  _break c
		inc	bp
	_loop
		mov	al,[bp]
		tst	al
	_if z
		mov	al,ATR_WTXT
		call	setatr
	_else
		call	set_attr
	_endif
		pop	bp
		ret
set_flatr	endp

;----- Put select marker -----
;--> AH :cursor mode

put_marker	proc
		call	getatr1
		push	ax
		test	[bx].dr_attr,FA_SEL
		mov	al,SPC
	_ifn z
		tst	ah
	  _if z
		mov	al,ATR_WTXT
		call	setatr
	  _endif
		mov	al,'*'
	_endif
		call	putc
		pop	ax
		call	setatr1
		ret
put_marker	endp

;----- Redraw Filer -----	#X

redraw_filer	proc
	mov	bx,offset cgroup:mb_filer
	call	drawmbar
	mov	bp,actwkp
	call	do_view1
	call	setflwind
	;jmp	bcsron
redraw_filer	endp

;--- Block cursor on/off ---

bcsron	proc
	mov	ah,TRUE
	skip2
bcsroff:
	mov	ah,FALSE
	call	issilent
	pushm	<bx,cx,ds>
	push	ax
	call	getpoolp
	mov	ds,dx
	call	set_flatr
	mov	dl,al
	pop	ax
	push	ax
	tst	ah
_ifn z
	test	ss:flmode,FM_FDCSR
  _if z
	mov	al,ATR_BCSR
	call	setatr
	test	[bx].dr_attr,FA_SEL
    _ifn z
	cmp	al,dl
      _if e
	mov	al,ATR_WTXT
	call	setatr
      _endif
    _endif
	call	undatr
  _else
	call	revatr
  _endif
_endif
	call	bcsrloc
	mov	cl,14
	cmp	ss:hfiles,5
_ifn e
	mov	cl,38
	call	tstlfn
  _ifn z
	mov	cl,78
  _endif
_endif
	test	ss:flmode,FM_FDCSR
_if z
	cmp	bx,[bp].fl_poolend	; ##156.127
  _if b
	test	[bx].dr_attr,FA_SEL
    _ifn z
	call	revatr
    _endif
  _endif
	test	ss:hardware,IDN_PC98
  _if z
	dec	cx
	call	fillatr
	pop	ax
	push	ax
	tst	ah
    _ifn z
	call	undatr
    _endif
	mov	cl,1
  _endif
_else
	call	locate
	pop	ax
	push	ax
	call	put_marker
	inc	dl
	dec	cx
_endif
	call	fillatr
	pop	ax
	popm	<ds,cx,bx>
	ret
bcsron	endp

bcsrloc proc
	mov	ax,[bp].fl_bcsr
bcsrloc1:
	sub	ax,[bp].fl_home
	cwd
	div	ss:hfiles
	shlm	dx,4
	mov	dh,al
	ret
bcsrloc endp

;--- Init pool ptr ---
;<-- BX :pool ptr

initpoolp proc
	mov	di,pool
	tstb	fldual
_ifn z
	mov	bx,[bp].fl_back
	mov	si,[bx].fl_pooltop
	tst	si
  _ifn z
	mov	cx,[bx].fl_poolend
	sub	cx,si
	pushm	<ds,es>
	mov	ds,[bp].fl_seg
	movseg	es,ds
	call	memmove
	popm	<es,ds>
	mov	ax,si
	sub	ax,di
	sub	[bx].fl_pooltop,ax
	sub	[bx].fl_poolend,ax
	sub	[bx].fl_poolp,ax
	add	di,cx
  _endif
_endif
	mov	bx,di
	mov	[bp].fl_pooltop,bx
	mov	[bp].fl_poolp,bx
	ret
initpoolp endp



;--- Read directory ---
;--> BX :pool ptr

readdir	proc
	mov	[bp].fl_overflow,FALSE
	mov	dx,tmpbuf3		; WD*2 ; 160  DTA,smooth,&?()
	msdos	F_SETDTA
	clr	cx			; CX :file counter
	lea	si,[bp].fl_mask
	mov	di,offset cgroup:mask_all
	mov	dl,FA_DIREC
	cmp	word ptr [si],'*'
_ifn e
	push	di
	call	strcmp
	pop	di
  _ifn e
	mov	dl,FA_DIREC+FA_SEL
  _endif
_endif
	mov	ah,F_FINDDIR
	mov	si,bx
_repeat
	call	getdir
_until c
	test	dl,FA_SEL
	jz	readdir8

	lea	si,[bp].fl_mask
	cmp	word ptr [si],'.'
_if e
	mov	si,extlist
_endif

_repeat
	call	skipspc
  _break c
	mov	di,pathbuf2
	push	di
	cmp	byte ptr [si],'.'
  _if e
	mov	al,'*'
	stosb
  _endif
	clr	ah
  _repeat
	lodsb
	stosb
	cmp	al,'.'
    _if e
	mov	ah,TRUE
    _endif
	cmp	al,SPC
  _while a
	dec	si
	dec	di
	tst	ah
  _if z
	mov	ax,'*.'
	stosw
  _endif
	clr	al
	stosb
	pop	di
	mov	ah,F_FINDDIR
	push	si
	mov	si,bx
  _repeat
	mov	dl,FA_SEL
	call	getdir
  _until c
	pop	si
	tst	si
_until z

readdir8:
	mov	[bp].fl_poolend,bx
	inc	cx			; End of dir
	tstw	[bp].fl_files		; ##16
_if z
	mov	[bp].fl_bcsr,0
_endif
	cmp	cx,[bp].fl_bcsr
_if b
	mov	ax,cx
	dec	ax
	mov	[bp].fl_bcsr,ax
_endif
	mov	[bp].fl_files,cx
	mov	[bp].fl_selcnt,0
	call	fsethome

;	call	getfre
nonfre:	call	sortdir			; ##d9.3
	ret

;readdir	endp


;=================================================================

getfre:
	mov	dl,0
;	msdos	F_GETDRV	;int21,36h	; Get Disk Free Space
;	mov	ah,curdrv ;36h
	mov	ax,cs:uso_free
	mov	cx,512
	mov	bx,0
	cmp	byte ptr cs:uso_free,1 ;ah			;##k07i
;	test	cs:tvzsw,TSW_USOFREE			;##k07i
	jae	readfre					;##k07i
	mov	ah,36h
	int	21h
readfre:
	cmp	ax,-1
_ifn e					; ##100.13
	mul	cx
	mov	[bp].fl_clust,ax
	mul	bx
	stl	[bp].fl_free
_endif
;	mul	bx			;dx0:ax1=bx*ax			;##k04
;	push	dx
;	mul	cx			;dx1:ax2=cx*ax1
;	mov	[bp].fl_clust,ax	;ax2
;	mov	bx,dx			;bx1=dx1
;	pop	ax			;ax3=dx0
;	mul	cx			;dx2:ax4=cx*ax3
;	add	bx,ax			;bx2=bx1+ax4
;	mov	ax,[bp].fl_clust	;ax2
;;	stl	[bp].fl_free		;
;	mov	word ptr [bp].fl_free,ax	;ax4
;	mov	word ptr [bp].fl_free+2,bx	;dx2

;	call	sortdir			; ##d9.3
	ret
readdir	endp

;--- Get one dir ---
;-->
; AH :funcion No.
; BX :pool ptr (update)
; CX :file count (update)
; DL :file attr
; SI :sort start ptr
; DI :mask string
;<--
; CY :no more files

getdir	proc
	cmp	bx,poolend
_if ae
	mov	[bp].fl_overflow,TRUE
	stc
getd9:	ret
_endif
	tstw	hidden
_ifn z
	or	dl,FA_SYSTEM+FA_HIDDEN
_endif
	call	finddir
	jc	getd9
	pushm	<di,ds,es>
	push	si
	mov	si,tmpbuf3		; WD*2 ; 160  DTA,smooth,&?()
	add	si,dta_attr
	mov	es,[bp].fl_seg
	push	cx
	mov	di,bx
	and	byte ptr [si],not FA_SEL	; ##156.104
	mov	cx,dta_pack-dta_attr
    rep	movsb
	mov	cx,PACKSZ
	push	di
	clr	al
    rep stosb
	pop	di
	push	di
	call	strcpy
	pop	si
	movseg	ds,es

	test	ss:dspsw,DSP_PATHCASE
_ifn z
	call	strlwr
_endif

	pop	cx
	test	dl,FA_SEL
_ifn z
	mov	al,[bx].dr_attr
	xor	al,dl
	test	al,FA_DIREC
	jnz	getd4
_endif
	mov	si,bx
	add	si,dr_pack
	cmp	word ptr [si],'.'
	je	getd4
	test	[bx].dr_attr,FA_DIREC
	jnz	getd3
	tstw	ss:archive
_ifn z
	test	[bx].dr_attr,FA_ARCH
	jz	getd4
_endif
	call	skip_ext
	jc	chktype
	push	cx
	call	isbinary
	mov	al,FT_ALL
	tst	ch
_ifn z
	or	[bx].dr_attr,FA_BINARY
	mov	al,FT_BIN
_endif
	pop	cx
chktype:
	mov	dh,ss:flbinary
	tst	dh
_ifn z
  _if g				; FT_TEXT
	mov	dh,FT_ALL
  _endif
	cmp	al,dh
	jne	getd4
_endif
getd3:
	inc	cx
	add	bx,type _dir
	mov	[bx].dr_attr,0
getd4:	pop	si
	popm	<es,ds,di>
	cmp	ah,F_FINDDIR
	jne	getd8
	inc	ah
getd8:	clc
	ret
getdir	endp

skip_ext proc
_repeat
	lodsb
	cmp	al,1
  _break b
	cmp	al,'.'
_until z
	ret
skip_ext endp

skip_extlfn proc
	push	bx
	clr	bx
	cmp	byte ptr [si],'.'
_if z
	inc	si
_endif
_repeat
	call	skip_ext
  _break c
	mov	bx,si
_until
	cmp	bx,1
_ifn c
	mov	si,bx
_endif
  	pop	bx
  	ret
skip_extlfn endp


;--- Sort directory ---
;-->

sortdir		proc
		pushall	<ds,es>
; ##d9.3
		tstb	sortopt
		jz	sort8
		mov	cx,[bp].fl_files
;;		sub	cx,1
;;		jbe	sort8
; ##d9.3
								; ##d10.1
		cmp	cx,2
		jbe	sort8
		dec	cx
								; ##d10.1
		mov	ax,[bp].fl_seg
		mov	ds,ax
		mov	es,ax
		call	set_h
sort1:		push	ax		; ax = h
		mov	cx,ax
		mov	dx,type	_dir
		mul	dx
		mov	si,[bp].fl_pooltop
_repeat
		mov	di,si
		add	di,ax
		push	si
	_repeat
		pushm	<si,di>
	  _repeat
		call	sortcmp
	    _break be
		call	memswap
		mov	di,si
		sub	si,ax
		jc	sort5
		cmp	si,[bp].fl_pooltop
	  _until b
sort5:		popm	<di,si>
		mov	si,di
		add	di,ax
		jc	sort6
		cmp	di,[bp].fl_poolend
	_while b
sort6:		pop	si
		add	si,type	_dir
_loop
		pop	ax		; pop h
		cmp	ax,1
		jz	sort8
		mov	cx,3
		clr	dx
		div	cx
		jmps	sort1
sort8:		popall	<es,ds>
		ret
sortdir		endp

sortcmp		proc
		pushm	<ax,cx,dx,si,di>
		cmp	word ptr [si].dr_pack,'..'
		stc
		jz	sortcmp9
		mov	cx,word ptr ss:sortopt
		mov	al,[si].dr_attr
		mov	ah,[di].dr_attr
		and	ax,(FA_DIREC shl 8) or FA_DIREC
	_ifn z
		cmp	ah,al
		jnz	sortcmp9
	_endif
		tst	cx
	_if s
		xchg	si,di
	_endif
; ##d9.1
		mov	ah,cl
		mov	al,(offset tb_cmpend - offset tb_cmp)/2
		mov	bx,offset cgroup:tb_cmp
	_repeat
		shr	ah,1
	  _break c
		shr	ah,1
	  _break c
		inc	bx
		inc	bx
		dec	al
	_until z
		call	cs:[bx]
; ##d9.1
sortcmp9:	popm	<di,si,dx,cx,ax>
nocmp:		ret
sortcmp		endp

tb_cmp:
	ofs	byname
	ofs	bytime
	ofs	bysize
tb_cmpend:
	ofs	nocmp

set_h		proc
		mov	ax,1
		test	byte ptr ss:sortopt,SORT_NAME+SORT_EXT	; ##d9.2
_ifn z
		mov	bx,cx		; cx = array cnt
	_repeat
		push	ax
		mov	cx,10
		mul	cx
		mov	dx,ax
		pop	ax
	  _break c
		cmp	dx,bx
	  _break a
		mov	cx,3
		mul	cx
		inc	ax
	_until
_endif
		ret
set_h		endp

memswap		proc
		pushm	<ax,cx,si,di>
		mov	cx,type _dir / 2
	_repeat
		mov	ax,[di]
		movsw
		mov	[si-2],ax
	_loop
		popm	<di,si,cx,ax>
		ret
memswap		endp

;--- Compare by name ---
;-->
; SI-DI :dir ptr
; DL :sort option

byname	proc
	add	si,dr_pack
	add	di,dr_pack
	test	cl,SORT_EXT
	mov	cx,12
_ifn z
	pushm	<si,di>
	call	skip_ext
	dec	si
	xchg	si,di
	call	skip_ext
	xchg	si,di
	dec	di
	mov	cl,4
   repz cmpsb
	popm	<di,si>
	jne	bynam9
	mov	cl,8
_endif
   repz cmpsb
bynam9:	ret
byname	endp


;--- Compare by time/size ---
;-->
; SI-DI :dir ptr
; DL :sort option

bysize	proc
	add	si,dr_size-dr_time
	add	di,dr_size-dr_time
	mov	al,SORT_LARGE
	jmps	bytime1
bytime	proc
	mov	al,SORT_NEW
bytime1:test	cl,al
_ifn z
	xchg	si,di
_endif
	ldl	[si].dr_time
	cmpl	[di].dr_time
	ret
bytime	endp
bysize	endp

;----- Speed Seach -----		; ##156.101
;--> AL :key
;    DH :inc search
do_search proc
	pushm	<ds,es>
	call	toupper
	mov	ah,al
	clr	cx
	test	cs:tvzsw,TSW_ISCH
_ifn z
	mov	cl,dh
_endif
	push	ax
	call	getpoolp
	pop	ax
	mov	ds,dx
	mov	es,dx
	mov	di,bx
	tst	cx
	jnz	dosrch5
_repeat
dosrch1:
	add	bx,type _dir
	cmp	bx,[bp].fl_poolend
  _if a
	mov	bx,[bp].fl_pooltop
  _endif
	cmp	bx,di
	je	sch_ng
	cmp	bx,[bp].fl_poolend
	je	dosrch1
  _ifn cxz
dosrch5:
	pushm	<cx,si,di>
	lea	si,[bx].dr_pack
	add	di,dr_pack
   repz	cmpsb
	lodsb
	popm	<di,si,cx>
	jnz	dosrch1
  _else
	mov	al,[bx].dr_pack
  _endif
	call	toupper
	cmp	al,ah
_until e
	inc	cl
	mov	ss:isearch,cl
	sub	bx,[bp].fl_pooltop
	mov	ax,bx
	cwd
	mov	cx,type _dir
	div	cx
	mov	cx,ax
	popm	<es,ds>
	jmp	fscroll
sch_ng:	popm	<es,ds>
	ret
do_search endp

;--- Check DIR in pool ---		; ##156.100
;<-- CY :exist

	public	check_dir
check_dir proc
	push	ds
	lds	bx,dword ptr [bp].fl_pooltop
_repeat
	mov	al,[bx].dr_attr
	and	al,FA_SEL+FA_DIREC
	cmp	al,FA_SEL+FA_DIREC
	je	exist_dir
	add	bx,type _dir
	cmp	bx,[bp].fl_poolend
_while b
	pop	ds
	clc
	ret
exist_dir:
	pop	ds
	stc
	ret
check_dir endp

	endcs

	eseg

;--- Get path from pool ---
;-->
; AL :full path
; ES:DI :result path ptr
;<--
; BX :name ptr

	public	getpool,getpool2
getpool proc
	pushm	<di,es>		; ## 10# mod
	call	getpool2
;	pushm	<bp,ds>
;	movseg	ds,ss
;	mov	bp,actwkp
;	call	cpyaccdir
;	call	mappoolseg
;	call	copyafile
;	popm	<ds,bp>
;-----------------------------------------------------------------------------
; ## 10# mod
	popm	<es,di>
;	test	cs:tvzsw,TSW_KEEPCASE			; ## 10# mod
;	test	word ptr cs:tvzsw,TSW_REN_FLG		; Rf1  #151120
	call	tstlfnr					;
	jnz	lfn_nm
;	test	cs:sl_sw,4			;##k sl 0:time 1:free
;	jz	sncpy97					;
	call	tstlfn					;
_ifn z
lfn_nm:	pushm	<ax,bx,cx,si,di,ds,es>
	mov	ax,es
	mov	si,di
	mov	ds,ax
		;  ̒Õ[`͕sôō폜
	mov	cx,8001h
	mov	ax,7160h  ;F_LFN_GETFULLPATH ; ASCIZ߽ɂ߽̒u
;  7160 01 | ߽Z߽Ŏ擾	| GetShortPathName
	int	21h
getp_l:
	popm	<es,ds,di,si,cx,bx,ax>
_endif
	jnc	sncpy97					;
	call	getpool2
sncpy97:
;-----------------------------------------------------------------------------
	ret

getpool2: pushm	<bp,ds>
	movseg	ds,ss
	mov	bp,actwkp
	call	cpyaccdir
	call	mappoolseg
	call	copyafile
	popm	<ds,bp>
	ret
	
getpool	endp

	public	copyafile
copyafile proc
	mov	ah,[si]			; ##156.100
	add	si,dr_pack
;	call	strcpy
;	test	ah,FA_DIREC
;_if z
;	tstb	[si]
;  _ifn z
;	mov	al,'.'
;	stosb
	call	strcpy
;  _endif
;_endif
	ret
copyafile endp

	assume	ds:nothing

;--- Search next file in pool ---
;--> CY :no more files

	public	nextpool
nextpool proc
	pushm	<bp,ds>
	mov	bp,actwkp
	mov	ds,[bp].fl_seg		; SS != CS
	call	nextpool1
	mov	[bp].fl_poolp,si
	popm	<ds,bp>
	ret

nextpool1:
	call	mappoolseg
_ifn c
	mov	al,byte ptr ss:basemode
	cmp	al,SYS_FILER
	je	npool2
 _repeat
	cmp	si,[bp].fl_poolend
	jae	npool3
	test	[si].dr_attr,FA_SEL
  _break nz
npool2:
	add	si,type _dir
 _until
	cmp	al,SYS_FILER
  _ifn e
	and	[si].dr_attr,not FA_SEL
	dec	[bp].fl_selcnt
  _endif
_endif
	clc
	ret
npool3:	clr	si
	stc
	ret
nextpool endp

mappoolseg proc
	mov	ax,farseg
	call	ems_map
	mov	ds,ax
	mov	si,[bp].fl_poolp
	tst	si
_if z
	pushm	<ax,bx>
	call	getpoolp
	mov	si,bx
	popm	<bx,ax>
	mov	[bp].fl_poolp,si
	stc
_endif
	ret
mappoolseg endp

;----- Scan first file -----

		public	scan_1st
scan_1st	proc
		call	getpoolp
		mov	ds,dx
		tstw	[bp].fl_selcnt
		jz	sc1st9
		mov	bx,[bp].fl_pooltop
_repeat
		cmp	bx,[bp].fl_poolend
	_break ae
		test	[bx].dr_attr,FA_SEL
	_break nz
		add	bx,type _dir
_until
sc1st9:		ret
scan_1st	endp

;----- Open from 2nd window -----

		public	chk_fldual
chk_fldual	proc
		push	bp
		tstb	fldual
	_ifn z
		mov	bp,actwkp
		mov	bp,[bp].fl_back
		tstw	[bp].fl_selcnt
	  _ifn z
		mov	actwkp,bp
	  _endif
	_endif
		pop	bp
		ret
chk_fldual	endp

	assume ds:cgroup

;--- Get pooled file name ---
;--> DS:SI :file name

	public	poolnamep
poolnamep proc
	push	bp
	mov	bp,actwkp
	mov	ds,[bp].fl_seg
	mov	si,[bp].fl_poolp
	tst	si
_ifn z
	add	si,dr_pack
_endif
	pop	bp
	ret
poolnamep endp

;--- Copy access directory ---

	public	cpyaccdir
cpyaccdir proc
	mov	bx,di
	lea	si,[bp].fl_path
	tstb	[bp].fl_curf
_if z
	tst	al
	jz	cpyac9
	call	strcpy
	call	addsep
	mov	bx,di
	ret
_endif
	call	strcpy
	call	addsep
cpyac9:	ret
cpyaccdir endp

;--- Select drive ---
;--> AL :drive No. (A=0)
;<-- CY :error (AL :drive count)

seldrv	proc
	mov	dl,al
	msdos	F_SELDRV		; ah=0eh int 21h
;	cmp	al,26			; ##156.120	; ##k07t
;_if a							; VTDOS
	mov	al,26
;_endif							; 
	mov	drive_c,al
	cmp	dl,al
	cmc
	ret
seldrv	endp


;--- Change path ---
;--> SI :dir name ptr

	public	chgpath,chpath
chgpath:
	test	dl,PRS_DRV
	jnz	chpath
	jmps	chpath1

setcurpath proc
	lea	si,[bp].fl_path
chpath:
	lodsb
	inc	si
	and	al,1Fh			; ##100.01
	dec	al
	call	seldrv
chpath1:mov	dx,si
	msdos	F_CHDIR
	ret
setcurpath endp

;--- Set access dir ---
;<-- CY :path not found

setaccdir proc
	mov	si,pathp
	lea	di,[bp].fl_path
	mov	dl,parsef
	tst	si
	jz	setac1
	test	dl,PRS_DRV+PRS_DIR
	jnz	setac2
setac1:	mov	si,di
	call	chpath
	jnc	setac9
resetaccdir:
	lea	di,[bp].fl_path		; ##156.??
	cmp	ax,-1			; ##152.15
	jne	getaccdir
	mov	si,curdir		; ##151.12
	call	chpath
	mov	[bp].fl_files,0
	jmps	getaccdir
setac2:
	test	dl,PRS_DRV
_if z
	xchg	si,di
_endif
	lodsb
	inc	si
	and	al,1Fh			; ##100.01
	dec	al
	test	dl,PRS_DRV
	jnz	setdrive
	xchg	si,di
setdrive:
	push	dx
	call	seldrv
	pop	dx
	jc	setac_x
	mov	di,pathbuf2
	test	dl,PRS_DIR
	jz	getaccdir
	mov	dx,di
	mov	bx,getnamp
	mov	al,[bx-1]
	call	isslash
_if e
	dec	bx
_endif
setac4:	movsb
	cmp	si,bx
	jb	setac4
	clr	al
	stosb
	msdos	F_CHDIR
	jc	setac_x1
	mov	di,dx
getaccdir:
	push	di
	call	getcurdir1
	pop	si
	jc	setac_x1
	lea	di,[bp].fl_path
	mov	[bp].fl_files,0		;; ##16
	call	strcpy
setac9:	clc
	ret
setac_x1:
	call	setcurpath
setac_x:stc
	ret
setaccdir endp

;--- Set mask ---

	public	setmask
setmask	proc
	mov	si,getnamp
	tst	si
	jz	stmsk9
	call	skipspc			; ##156.94
	tstb	[si]
	jz	stmsk9
setmask1:
	mov	flbinary,FT_ALL
setmask2:
	lea	di,[bp].fl_mask
	mov	cx,MASKSZ-1
	call	strncpy
stmsk9:	ret
setmask endp

;----- Check DOS_GO flag -----
;--> SI:xbuf
;<-- CY: DOS_GO on (SI:buffer)

		public	dos_go
dos_go		proc
		test	dossw,DOS_GO
		jz	dosgo9
		push	si
		mov	di,tmpbuf	; TMPSZ ; 256  temporary work
		push	di
		mov	al,LF
		mov	cx,TMPSZ		; 256
	repne	scasb
		dec	di
		pop	si
		pop	bx
		clr	cx
		push	bx
		call	histcpy
		pop	si
		stc
dosgo9:		ret
dos_go		endp


	endes


ENDIF		;IFNDEF NOFILER
	end

;****************************
;	End of 'filer.asm'
; Copyright (C) 1989 by c.mos
; arranged by H.Takahashi
;****************************
