;****************************
;	'char.asm'
;****************************
;	$Revision: 3.3 $

	include	vz.inc

	extrn	sl_sw		:byte		;
	extrn	tvzsw		:near		;## 10# mod

	bseg

;--- Is upper/lower/alpha? ---
;<-- CY :yes

		public	isalpha,isupper,islower
isalpha		proc
		cmp	al,'a'
		jnb	islow1
isupper:	cmp	al,'A'
		jb	notalp
		cmp	al,'Z'+1
		ret
islower:	cmp	al,'a'
		jb	notalp
islow1:		cmp	al,'z'+1
		ret
notalp:		clc
		ret
isalpha		endp

	endbs

	eseg

;--- Is digit ? ---
;<-- CY :'0'-'9'

	public	isdigit
isdigit proc
	cmp	al,'0'
	jb	kjno
	cmp	al,'9'+1
	ret
isdigit endp

;--- Is kanji ? ---
;<-- CY :kanji

	public	iskanji
iskanji	proc
	ifkanji kjyes
kjno:	clc
kjyes:	ret
iskanji	endp


;--- Char to upper/lower case ---
;--> AL :char
;<-- CY :converted

	public	toupper2,toupper,tolower
toupper2	proc	
	test	word ptr cs:tvzsw,TSW_REN_FLG	; Rf1 啶ʕ\
	jnz	lfn_v8
	test	cs:sl_sw,2			;##k sl 2:LFN View  230304
	jnz	lfn_v8
toupper:
	cmp	al,'a'
	jb	kjno
	cmp	al,'z'
_ifn a	
	add	al,-('a'-'A')
_endif
lfn_v8:
	ret
;toupper	endp
toupper2	endp

tolower	proc	
	call	isupper
_if c
	sub	al,-('a'-'A')
_endif
	ret
tolower	endp


;--- String to upper/lower case ---
; DS:SI :string ptr

	public	strupr,strlwr
strupr	proc
	push	bx
	mov	bx,offset cgroup: toupper
	jmps	strup1
strlwr:
	push	bx
	mov	bx,offset cgroup: tolower
strup1:
_repeat
	lodsb
	tst	al
  _break z
	call	iskanji
	jc	strup2
	call	bx
  _cont nc
	mov	[si-1],al
  _cont
strup2:	inc	si
_until
	pop	bx
	ret
strupr	endp


;--- Copy string ---
;-->
; DS:SI :source ptr
; ES:DI :destin ptr
;<--
; DS:DI=string end

	public	strcpy
strcpy	proc
_repeat
	lodsb
	stosb
	tst	al
_until z
	dec	di
	ret
strcpy	endp

;--- Copy string (max) ---
;-->
; DS:SI :source ptr
; ES:DI :destin ptr
; CX :maximum byte
;<-- 
; ES:DI string end
;work si,di,ax,cx

	public	strncpy
strncpy proc
	jcxz	sncpy2
_repeat
	lodsb
	stosb
	tst	al
	jz	sncpy3
_loop
sncpy2:	clr	al
	stosb
sncpy3:	dec	di
	ret
strncpy endp

;--- Copy word ---
;-->
; DS:SI :source ptr
; ES:DI :destin ptr
;<--
; DS:SI = word end
; ES:DI = string end
; AL    = panct chaer  

	public	wrdcpy
wrdcpy	proc
_repeat
	lodsb
	stosb
	cmp	al,SPC
_until be
	dec	si
	dec	di
	mov	byte ptr es:[di],0	
	ret
wrdcpy	endp

;--- Compare two strings ---
;--> SI,DI :string ptr
;<-- ZR :equal

	public	strcmp,strcmp1
strcmp	proc
	pushm	<si,di>
	call	strcmp1
	popm	<di,si>
	ret
strcmp	endp

strcmp1	proc
	push	cx
	push	di
	clr	al
	mov	cx,-1
  repnz scasb
	not	cx
	pop	di
    rep cmpsb
	mov	al,es:[di-1]
	pop	cx
	ret
strcmp1	endp

;----- Ignore case compare -----
;--> SI,DI :string ptr
;<-- ZR :equal

	public	stricmp
stricmp	 proc
	pushm	<si,di>
_repeat
	lodsb
	call	iskanji
  _if c
	dec	si			; Ή
	mov	al,es:[di]		;
	cmpsw
  _else
	call	toupper
	mov	ah,al
	mov	al,es:[di]
	inc	di
	call	toupper
	cmp	ah,al
  _endif
	jne	scmp8
	tst	al
_until z
scmp8:	popm	<di,si>
	ret
stricmp	endp


;--- Ignore case word compare ---
;--> SI,DI :string ptr
;<-- CY :equal

	public	wrdicmp
wrdicmp	proc
	push	si
_repeat
	lodsb
	call	iskanji			;
  _if c					; Ή
	dec	si			;
	cmpsw				;
  _else				;
	call	toupper			
	mov	ah,al			
	mov	al,es:[di]		
	inc	di
	call	toupper
	cmp	al,SPC
	jbe	wcmp1
	cmp	al,ah
  _endif
_while e
wcmp_x:	clc
	dec	di
	jmps	wcmp9
wcmp1:	cmp	ah,SPC
	ja	wcmp_x
	stc
wcmp9:	mov	ax,si			; AX=next si
	pop	si
	ret
wrdicmp	endp

;--- String length ---
;--> DS:SI :string ptr
;<-- AX :length

	public	strlen
strlen	proc
	pushm	<cx,di,es>
	movseg	es,ds
	mov	di,si
	call	skipstr
	not	ax
	dec	ax
	popm	<es,di,cx>
	ret
strlen	endp

;--- skipstr ---
;--> es:di
;<-- es:di next string ptr

	public	skipstr
skipstr	proc
	push	cx
	clr	al
	mov	cx,-1
  repnz	scasb
	mov	ax,cx
	pop	cx
	ret
skipstr	endp

;--- strskip ---
;--> ds:si = string ptr
;<-- ds:si = next string ptr

	public	strskip
strskip	proc
	pushm	<di,es>
	mov	di,si
	movseg	es,ds
	call	skipstr
	mov	si,di
	popm	<es,di>
	ret
strskip	endp


;--- Skip SPC,TAB ---
;<--
; CY :end of line
; NC :next char

		public	skipchar,skipcharq,skipspc,skipspc1
skipchar	proc			; ##d7 "" Ή
	push	ax
	jmps	skipchar1
skipcharq:				; lfn spc
	push	ax
	lodsb
	cmp	al,'"'
_if z
	mov	ah,al
_else
	dec	si
skipchar1:
	mov	ah,SPC
_endif
	_repeat
		lodsb
		cmp	al,SPC
	  _break b
		cmp	al,ah
	_until z
	_if z
		cmp	ah,'"'
		jz	skipchar8	; '"' ͓ǂݒȂ
	_endif
		dec	si
skipchar8:	pop	ax
skipspc:	lodsb
skipspc1:	cmp	al,TAB
		je	skipspc
		cmp	al,SPC
		je	skipspc
skpspc8:	dec	si
		ret
skipchar	endp


;--- Change LF to NULL ---
;--> DI :string ptr
;<-- AX :string length

	public	lftonull
lftonull proc
	push	cx
	mov	cx,-1
	mov	al,LF
  repne	scasb
	dec	di
	mov	ax,cx
	not	ax
	dec	ax
	mov	byte ptr [di],0
	pop	cx
	ret
lftonull endp

;--- Scan CS:table ---

	public	scantbl
scantbl	proc
	push	es
	movseg	es,cs
  repne	scasb
	pop	es
	ret
scantbl	endp

;----- strchr(s,c) -----
;-->
; si = ptr
; dx = c
;<-- CY :found(SI:ptr, CX:index)

		public	strchr,strichr
strchr		proc
		push	bx
		mov	bl,FALSE
		jmps	strchr1
strichr:	push	bx
		mov	bl,TRUE
		xchg	ax,dx
		tst	ah
	_if z
		call	toupper
	_endif
		xchg	ax,dx
strchr1:
		clr	cx
_repeat
		inc	cx
		lodsb
		tst	bl
	_ifn z
		call	toupper
	_endif
		clr	ah
		tst	al
		jz	strchr_x
	_if s
		call	iskanji
	  _if c
		mov	ah,al
		lodsb
	  _endif
	_endif
		cmp	ax,dx
_until e
		dec	cx
		dec	si
		tst	ah
	_ifn z
		dec	si
	_endif
		stc
strchr_x:	pop	bx
		ret
strchr		endp

;----- strstr(si,di) -----
;<-- CY :found

		public	strstr,stristr
strstr		proc
		push	bx
		mov	bx,offset cgroup: strcmp
		jmps	strstr1
stristr:	push	bx
		mov	bx,offset cgroup: stricmp
strstr1:	tst	cx
	_if z
		dec	cx
	_endif
		tstb	[si]
		jz	strstr9
		tst	di
		jz	strstr9
	_repeat
		call	bx
		tst	al
		stc
		je	strstr9
		lodsb
		call	iskanji
		adc	si,0
		tstb	[si]
		jz	strstr8
	_loop
strstr8:	clc
strstr9:	pop	bx
		ret
strstr		endp

	endes
	end

;****************************
;	'char.asm'
; Copyright (C) 1989 by c.mos
; arranged by H.Takahashi
;****************************
