;------------------------------------------------
; sprintf.inc	$Revision: 3.2 $
;
;		Copyright (c) 1991 by c.mos
;               arranged by H.Takahashi
;------------------------------------------------

;----- Equations -----

PF_LEFT		equ	 000001b
PF_ZERO		equ	 000010b
PF_LONG		equ	 000100b
PF_MINUS	equ	 001000b
PF_TRIPLE	equ	 010000b		; ,
PF_FARPTR	equ	 100000b		; %Fs
PF_PILIOD	equ	1000000b		; .		 ##k


;----- Local work -----

_printwk	struc
pmode		db	?
		db	?
pnum		db	?
knjh		db	?
_printwk	ends


;------------------------------------------------
;	sprintf
;------------------------------------------------
;-->
; DS:SI :format string ptr
;*ES:DI :output buffer ptr
; SS:BX :parameter top ptr
; $ld_strseg :load %s str seg to DS
;   usage :" %[-][0][*][n][,][l][F]{b|d|u|x|c|s} "
;   usage :" %[-][0][*][n][,][.][l][F]{b|d|u|x|c|s} "		 ##k

$sprintf	proc
		pushm	<bx,cx,dx,si,bp,ds,es>
		sub	sp,type _printwk
		mov	bp,sp
		skip1	al
prnt1:
		stosb
prnt2:		lodsb
		tst	al
		jz	prnt8
		cmp	al,'%'
		jne	prnt1
		lodsb
		cmp	al,'%'
		je	prnt1
		call	prnt_form
		jmp	prnt2
prnt8:
		stosb
		add	sp,type _printwk
		popm	<es,ds,bp,si,dx,cx,bx>
		ret
$sprintf	endp

;----- Analyze format -----

prnt_form	proc
		clr	ah
		cmp	al,'-'
	_if e
		or	ah,PF_LEFT
		lodsb
	_endif
		cmp	al,'0'
	_if e
		or	ah,PF_ZERO
		lodsb
	_endif
		mov	[bp].pmode,ah
		cmp	al,'*'			;
	_if z					; %*d
		mov	dx,ss:[bx]		;
		inc	bx			;
		inc	bx			;
		lodsb				;
	_else					;
		call	scandeci
	_endif
		mov	[bp].pnum,dl
		cmp	al,','
	_if e
		or	[bp].pmode,PF_TRIPLE
		lodsb
	_endif
		cmp	al,'.'					; ##k
	_if e							;
		or	[bp].pmode,PF_PILIOD			;
		lodsb						;
	_endif
		cmp	al,'l'
	_if e
		or	[bp].pmode,PF_LONG
		lodsb
	_endif
		cmp	al,'F'			;
	_if e					; %Fs
		or	[bp].pmode,PF_FARPTR	;
		lodsb				;
	_endif					;
		mov	dl,al
		mov	ax,ss:[bx]
		inc	bx
		inc	bx
		cmp	dl,'b'
		jmpl	z,prnt_bit
		cmp	dl,'c'
		je	prnt_chr
		cmp	dl,'s'
		je	prnt_str
		cmp	dl,'d'
		je	prnt_deci
		cmp	dl,'x'
		je	prnt_hexa
		cmp	dl,'u'
		je	prnt_unsigned
		ret

;----- %c : character -----

prnt_chr:
		tst	ax
	_ifn z
		tst	ah
	  _if z
		stosb
	  _else
		xchg	al,ah
		stosw
	  _endif
	_endif
		ret

;----- %s : string -----

prnt_str:
		pushm	<si,ds>
		test	[bp].pmode,PF_FARPTR		;
	_ifn z						; %Fs
		mov	ds,ss:[bx]			;
		inc	bx				;
		inc	bx				;
	_else						;
		$ld_strseg
	_endif
		mov	si,ax
		tst	si
		jz	pstr8
		clr	ah
		clr	cl
		mov	ch,[bp].pnum
_repeat
		lodsb
		tst	al
		jz	pstr1
		stosb
		inc	cl
		tst	ch
	_cont z
		cmp	cl,ch
_while b
		jmps	pstr8
pstr1:
		test	[bp].pmode,PF_LEFT
		jz	pstr8
		sub	cl,ch
	  	jnc	pstr8
		neg	cl
		clr	ch
		mov	al,SPC
	rep	stosb
pstr8:		popm	<ds,si>
		ret

;----- %x,%u,%d : number -----
;(special thanks to Oh!No! & moritan)

prnt_deci:
		movhl	cx,TRUE,10
		cwd
		jmps	pnum1
prnt_hexa:
		mov	cl,16
		jmps	pnum0
prnt_unsigned:
		mov	cl,10
pnum0:		mov	ch,FALSE
		clr	dx
pnum1:
		test	[bp].pmode,PF_LONG
	_ifn z
		mov	dx,ss:[bx]
		inc	bx
		inc	bx
	_endif
		tst	ch
	_ifn z
		clr	ch
		tst	dx
	  _if s
		neg	ax
		adc	dx,0
		neg	dx
		test	[bp].pmode,PF_ZERO
	    _ifn z
		mov	byte ptr es:[di],'-'
		inc	di
		dec	[bp].pnum
	    _else
		or	[bp].pmode,PF_MINUS
	    _endif
	  _endif
	_endif
		pushm	<bx,si>
		mov	bx,cx
		clr	cx
_repeat
pnum2:		inc	cx
		test	cl,3
	_if z
		test	[bp].pmode,PF_PILIOD			;##k
	  _ifn z
		mov	si,'.'					;
		push	si
		inc	cx
	  _endif						;
		test	[bp].pmode,PF_TRIPLE
	  _ifn z
		mov	si,','
		push	si
		inc	cx
	  _endif
	_endif
		push	ax
		mov	ax,dx
		clr	dx
		div	bx
		mov	si,ax
		pop	ax
		div	bx
		xchg	ax,dx
		cmp	al,10		;
		sbb	al,69h		; Tricky !
		das			;
		push	ax
		mov	ax,dx
		mov	dx,si
		or	si,ax
_until z
		test	[bp].pmode,PF_ZERO
	_ifn z
		cmp	cl,[bp].pnum
		jb	pnum2
	_endif
		test	[bp].pmode,PF_MINUS
	_ifn z
		pushi	'-'
		inc	cx
	_endif
		sub	[bp].pnum,cl
	_if b
		mov	[bp].pnum,0
	_endif
		test	[bp].pmode,PF_LEFT
	_if z
		call	prnt_fill
	_endif
_repeat
		pop	ax
		stosb
		dec	cx
_until z
		test	[bp].pmode,PF_LEFT
	_ifn z
		call	prnt_fill
	_endif
		popm	<si,bx>
		ret

;----- %b : bit -----

prnt_bit:
		push	bx
		clr	dx
		test	[bp].pmode,PF_LONG
	_ifn z
		mov	dx,ss:[bx]
		inc	bx
		inc	bx
	_endif
		clr	ch
		mov	cl,[bp].pnum
		tst	cx
	_if z
		mov	cl,16
		test	[bp].pmode,PF_LONG
	  _ifn z
		mov	cl,32
	  _endif
	_endif
		mov	bx,cx
	_repeat
		shr	dx,1
		rcr	ax,1
		pushf
	_loop
		mov	cx,bx
	_repeat
		popf
		mov	al,'0'
		adc	al,0
		stosb
	_loop
		pop	bx
		ret


;----- Fill space or '0' -----

prnt_fill	proc
		push	cx
		mov	cl,[bp].pnum
		clr	ch
		tst	cx
	_if g
		mov	al,' '
	rep	stosb
	_endif
		pop	cx
		ret
prnt_fill	endp

prnt_form	endp

;------------------------------------------------
;	Scan decimal
;------------------------------------------------
;-->
; SI :pointer
; AL :1st char
;<--
; DX :number
; AL :next char

		public	scandeci
scandeci	proc
		clr	dx
_repeat
		cmp	al,'0'
	_break b
		cmp	al,'9'
	_break a
		sub	al,'0'
		cbw
		push	ax
		mov	ax,10
		mul	dx
		mov	dx,ax
		pop	ax
		add	dx,ax
		lodsb
_until
		ret
scandeci	endp

;------------------------------------------------
;	End of sprintf.inc
;------------------------------------------------
