;****************************
;	'keyIBM.asm'
;****************************
;	$Revision: 3.6k07s3 $

;--- Equations ---

IFDEF DOSV
DOSV_BLINK	equ	TRUE
ENDIF

NKEYCNT		equ	4
IFDEF JBM
XKEYMAX		equ	084h
XKEYMAX2	equ	XKEYMAX
ELSE
XKEYMAX		equ	0A5h
;XKEYMAX2	equ	0BAh	;0B2h
XKEYMAX2	equ	0B2h			; 
ENDIF

KEY_SHIFT	equ	00000011b		; 03h
KEY_CTRL	equ	00000100b		; 04h
KEY_ALT		equ	00001000b		; 08h

_@F		equ	10000000b		; 80h
S@F		equ	10100000b		; A0h
C@F		equ	11000000b		; C0h
A@F		equ	11100000b		; E0h
@SFT		equ	00100000b		; 20h
@CTR		equ	01000000b		; 40h
@ALT		equ	01100000b		; 60h
@PGUP		equ	10010000b		; 90h
@PGDN		equ	10010001b		; 91h
@INS		equ	10010010b		; 92h
@DEL		equ	10010011b		; 93h
@UP		equ	10010100b			; 94h
@LEFT		equ	10010101b		; 95h
@RIGHT		equ	10010110b		; 96h
@DOWN		equ	10010111b		; 97h
@HOME		equ	10011000b		; 98h
@END		equ	10011001b		; 99h
@ESC		equ	10011010b		; 9Ah
@TAB		equ	10011011b		; 9Bh
@BS		equ	10011100b			; 9Ch
@CR		equ	10011101b			; 9Dh
@NFER		equ	10011110b		; 9Eh
;@XFER		equ	10011111b		; 9Fh
@RLDN		equ	10011111b		; 9Fh
@RLUP		equ	10100000b		; A0h
@CLR		equ	10100001b		; A1h
@HELP		equ	10100010b		; A2h

IFDEF J31
INT_ATOK	equ	6Fh
INT_WXP		equ	6Ch
ENDIF

IFDEF JBM
INT_ATOK	equ	60h
INT_IBM		equ	16h
INT_VJEB	equ	0F7h
ENDIF

ringp		equ	041Ch

	bseg
GDATA stopintnum,dw,	1Bh*4
	endbs

;--- External symbols ---

	wseg
	extrn	dspkeyf		:byte
	extrn	fkeymode	:byte
	extrn	cmdlinef	:byte
	extrn	had_err		:byte				;##k07
;	extrn	csrblnk		:word
;	extrn	hp_lx		:word

	extrn	fkeytbl		:word
	extrn	omori_fkey	:word
	endws

	extrn	abputc1		:near
	extrn	chkscreen	:near
	extrn	dosheight	:near
	extrn	getatr		:near
	extrn	iskanji		:near
	extrn	mkscrnp		:near
IFDEF DOSV
	extrn	vrestore	:near
	extrn	vrefresh	:near
  IFDEF DOSV_BLINK
	extrn	blinkcsr	:near
;	extrn	blink2		:near
	extrn	csrchr		:word
;	extrn	csrmode		:byte
  ENDIF
	extrn	readparm	:near
ENDIF

	hseg

;--- Constants ---

		public	tb_xkey,tb_xkeycvt
tb_xkey		db	"PGUPPGDNINS DEL UP  <-- --> DOWNHOMEEND "	;10
		db	"ESC TAB BS  CR  NFER"				;5
		db	"RLDNRLUPCLR HELP"				;4

tb_nkeycode	db	1Bh,09h,08h,0Dh

tb_fkeyspc10	db	10,6,1,1,1,1,4,1,1,1,1,1;4
tb_fkeyspc12	db	12,5,1,1,1,2,1,1,1,2,1,1,1,1;3		;##K07r4 

;		db	0,1,2,3,4,5,6,7,8,9,0Ah,0Bh,0Ch,0Dh,0Eh
tb_xkeycvt	db	@SFT+@TAB					; 0Fh
;		db	"QWERTYUIOP[]",0,0,"AS"				; 10h
		db	"QWERTYUIOP@[",0,0,"AS"				; 10h
;				   1A=@@ 1B=@[		; ##k07r
;		db	"DFGHJKL",0,0,"@",0,"\ZXCV"			; 20h
;		db	"DFGHJKL;:@",0,"]ZXCV"		; 20h
		db	"DFGHJKL",0,0,"@",0,"]ZXCV"			; 20h
;				 28          2B=@]	; ##k07r
;		db "BNM<>?"   ,0,0,0,0,0,_@F+1,_@F+2,_@F+3,_@F+4,_@F+5	; 30h
		db "BNM",0,0,0,0,0,0,0,0,_@F+1,_@F+2,_@F+3,_@F+4,_@F+5	; 30h
		db _@F+6,_@F+7,_@F+8,_@F+9,_@F+10,0,0,@HOME		; 40h
		db	@UP,@PGUP,0,@LEFT,0,@RIGHT,0,@END		; 48h
		db	@DOWN,@PGDN,@INS,@DEL,S@F+1,S@F+2,S@F+3,S@F+4	; 50h
;		db	50h  ,51h  ,52h ,53h ,54   ,55   ,56   ,57 	; 50h
		db	S@F+5,S@F+6,S@F+7,S@F+8,S@F+9,S@F+10,C@F+1,C@F+2 ;58h
		db	C@F+3,C@F+4,C@F+5,C@F+6,C@F+7,C@F+8,C@F+9,C@F+10 ;60h
		db	A@F+1,A@F+2,A@F+3,A@F+4,A@F+5,A@F+6,A@F+7,A@F+8  ;68h
		db	A@F+9,A@F+10,0,@CTR+@LEFT,@CTR+@RIGHT,@CTR+@END  ;70h
IFDEF JBM		; 70   71   72   73         74         75
		db	@CTR+@PGDN,@CTR+@HOME,"1234567890-^",@CTR+@PGUP
ELSE
;		db @CTR+@PGDN,@CTR+@HOME,_@F+1,_@F+2,_@F+3,_@F+4,_@F+5,_@F+6
		db @CTR+@PGDN,@CTR+@HOME,_@F+11,_@F+12,_@F+13,_@F+14,_@F+15,_@F+6
;		db @CTR+@PGDN,@CTR+@HOME,"1234567890"
;		   76 $D8    ,77 $81	  78	   81
		db _@F+7,_@F+8,_@F+9,_@F+10				; 7Eh
;		db	_@F+11,_@F+12,@CTR+@PGUP,_@F+11,_@F+12,S@F+11	; 82h
		db "_^"              ,@CTR+@PGUP,_@F+11,_@F+12,S@F+11	; 82h
;		   82=@-,83=@^,84 $D0    ,85 $8B			; 82h
		db	S@F+12,C@F+11,C@F+12,A@F+11,A@F+12		; 88h
		db	@CTR+@UP,0,0,0,@CTR+@DOWN,@CTR+@INS,@CTR+@DEL	; 8Dh
		db	@CTR+@TAB,0,0,@ALT+@HOME,@ALT+@UP,@ALT+@PGUP,0	; 94h
		db	@ALT+@LEFT,0,@ALT+@RIGHT,0,@ALT+@END,@ALT+@DOWN ; 9Bh 
		db	@ALT+@PGDN,@ALT+@INS,@ALT+@DEL,0,@ALT+@TAB	; A1h
;		db	@ALT+@PGDN,@ALT+@INS,@ALT+@DEL,"/",@ALT+@TAB	; A1h
		db	0						; A6h
;		db	@RLUP,@SFT+@RLUP,@CTR+@RLUP,@ALT+@RLUP		; A7h
		db	@RLDN,@SFT+@RLDN,@CTR+@RLDN,@ALT+@RLDN		; A7h
;		db	@XFER,@SFT+@XFER,@CTR+@XFER,@ALT+@XFER		; A7h
;		db	0,0,0,0						; A7h
		db	@NFER,@SFT+@NFER,@CTR+@NFER,@ALT+@NFER		; ABh
;			AB00  AC00       AD00       AE00
;		db	@CLR,@SFT+@CLR,@CTR+@CLR,0			; AFh 
;		db	0,0,0,0			; AFh 
		db	_@F,S@F,C@F,A@F			; AFh /S
;									; B2h
tb_xkeyscan	dw 0300h,1C0Ah,1C00h   ,0E00Ah  ,0A600h,007Fh,0E7Fh,0E00h,0100h
tb_xkeycode	db 0 ,@CTR+@CR,@ALT+@CR,@CTR+@CR,@ALT+@CR,@CTR+@BS,@CTR+@BS,@ALT+@BS,@ALT+@ESC
;----------------------------
ENDIF

;--- FEP table ---

IFNDEF US
		public	tb_fep
tb_fep:
IFDEF J31
		_fep	<INT_ATOK,33h,1,'7K'>
		_fep	<INT_ATOK,03h,1,'TA'>
		_fep	<INT_WXP ,22h,0,'XW'>	; ##155.78
		db	FP_MSKANJI
		db	0
ENDIF
IFDEF DOSV
		db	FP_MSKANJI
		_fep	<FP_DEVICE,offset cgroup:fpn_ias>
		db	0
fpn_ias		db	"$IBMAIAS"
ENDIF
IFDEF JBM
		_fep	<INT_ATOK, 33h, 1, '7K'>     ; ATOK7
		_fep	<INT_ATOK, 10,	0, 'TA'>     ; ATOK6
		_fep	<1,offset cgroup:fpn_ibm>    ; IBMA
		_fep	<INT_VJEB, 12h, 0, 'JV'>     ; VJE
		db	FP_MSKANJI
		db	0
fpn_ibm		db	"$IBMAK01"
vct16		dd	0
ENDIF
IFDEF IBMAX
		db	FP_MSKANJI
		db	0
ENDIF
		db	0				; ##k07t2 14-05-11
vct16		dd	0				; tVZŔĂ

	assume	ds:cgroup

;--- FEP control routine ---

fpctr	macro	fep
	dw	offset cgroup:fep&_on
	dw	offset cgroup:fep&_off
	dw	offset cgroup:fep&_act
	dw	offset cgroup:fep&_mask
	endm

tb_fepjmp:
	fpctr	msk			; ##156.90

;--- FEP control for J31 ---

IFDEF J31
	fpctr	atok7
	fpctr	atok
	fpctr	wxp

atok_on:
atok7_on:
	tst	al
_if z
	mov	al,0Bh
_endif
	mov	ah,al
	int	INT_ATOK
	ret
atok_off:
atok7_off:
	mov	ah,66h
	int	INT_ATOK
	push	ax
	mov	ah,0Bh
	int	INT_ATOK
	pop	ax
	ret

atok_act:
	mov	ah,20h
	int	INT_ATOK
	ret
atok_mask:
	mov	ah,1Fh
	int	INT_ATOK
	ret

wxp_on:					; ##155.78
	mov	ah,0
	int	INT_WXP
	ret
wxp_off:
	mov	ah,4Ch
	int	INT_WXP
	push	ax
	mov	ax,0
	int	INT_WXP
	pop	ax
	ret
wxp_act:
	mov	ax,5300h
	int	INT_WXP
	ret
wxp_mask:
	mov	ax,5301h
	int	INT_WXP
	ret
ENDIF

;--- FEP control for DOS/V ---

IFDEF DOSV
	fpctr	ias

	public	ias_on
ias_on	proc
;ias_on:
	push	ax
	mov	bx,1
	bios_v	1Dh,0		; mov ax,1D00h  INT10h  VIDEO - DOS/V - SHIFT STATUS LINE CONTROL
	bios_k	14h,0		; mov ax,1400h  INT16h  DOS/V - SHIFT STATUS DISPLAY CONTROL
	bios_k	13h,1		; mov ax,1301h  INT16h  al,01h get shift status
	pop	ax
	mov	dl,al		; Return:  DX = current shift status
	bios_k	13h,0		; mov ax,1300h  INT16h  al,00h set shift status
	ret
ias_off:
	bios_k	13h,1		; mov ax,1301h  INT16h  al,01h get shift status
	push	dx		; Return:  DX = current shift status
	and	dl,01000000b		; ##157.152
	bios_k	13h,0		; mov ax,1300h  INT16h  al,00h set shift status
	pop	ax
	ret
ias_on endp
ENDIF

;--- FEP control for PS/55 ---

IFDEF JBM
	fpctr	atok7
	fpctr	atok
	fpctr	ibm
	fpctr	vje

atok_on:
atok7_on:
	tst	al
_if z
	mov	al,0Bh
_endif
	mov	ah,al
	int	INT_ATOK
	ret
atok_off:
atok7_off:
	mov	ah,66h
	int	INT_ATOK
	push	ax
	mov	ah,0Bh
	int	INT_ATOK
	pop	ax
	ret
atok_act:
	mov	ah,20h
	int	INT_ATOK
	ret
atok_mask:
	mov	ah,1Fh
	int	INT_ATOK
	ret
atok7_mask:
	mov	ah,66h
	int	INT_ATOK
	tst	al
	je	fep_mask2
	jmp	msk_mask
vje_mask:
	mov	ah, 0
	int	INT_VJEB
	tst	al
	je	fep_mask2
	pushm	<dx,di,es>
	clr	ax
	mov	es,ax
	les	di,es:[16h*4]		;88  58h
	mov	cs:vct16.@off,di
	mov	cs:vct16.@seg,es
	push	si
	mov	ax,3F00h
	int	INT_VJEB	; IWi int 16h𓾂
	mov	ax,si
	pop	si
	jmp	ibmm1
fep_mask2:
	clr	ax
	mov	cs:vct16.@seg,ax
	ret
;; VJÉAcall sense_key ; original int 16 ɕύX ; call wait_key 
;; sȂƐ sense R[hȂ̂Œ
vje_on:
	mov	ah,1
	int	INT_VJEB
	ret
vje_off:
	mov	ah,0
	int	INT_VJEB
	push	ax
	movhl	ax,1,0
	int	INT_VJEB
	pop	ax
	ret

ibm_mode:
	bios_k	02h
	mov	al,ah
	and	al,1
	and	ah,6
	shl	ah,1
	or	al,ah
	push	es
	push	ax
	mov	ax,0E000h	; ʂ̍ŉs
	mov	es,ax
	cmp	byte ptr es:[24*160+18*2],' '	; ϊ 󔒂ł͂Ȃ
	pop	ax
	pop	es
  _ifn z
	or	al, 40h
  _endif
	or	al, 30h
	ret	   
ibm_act:
	mov	al,cs:mask_act
ibm_on:
	or	al, 30h
	bios_k	05h
	ret
ibm_off:
	call	ibm_mode
	push	ax
	mov	al,30h
	bios_k	05h
	pop	ax
	ret
ibm_mask:
	call	ibm_mode
	mov	cs:mask_act,al
	mov	al,30h
	bios_k	05h
	ret
ENDIF

;--- MS-KANJI API ---

msk_on:
	mov	ah,80h
	call	mskanji
	ret

msk_off:
	mov	ax,0
	call	mskanji
	push	Func0
	mov	ax,8001h
	call	mskanji
	pop	ax
	ret

mskanji	proc
	push	bp
	mov	bp,sp
	push	bx
	mov	bx,sp
	mov	Func0,ax
	push	ss
	pushi	<offset cgroup:Func>
	call	KKfunc
	mov	sp,bx
	pop	bx
	pop	bp
	ret
mskanji	endp

;--- Mask FEP for IBM ---

IFDEF J31
atok7_act:
ENDIF
IFDEF DOSV
ias_act:
ENDIF
IFDEF JBM
atok7_act:
vje_act:
ENDIF
msk_act:
	mov	al,byte ptr cs:mask_act
	call	word ptr cs:[bx-4]
	ret
IFDEF J31
atok7_mask:
ENDIF
IFDEF DOSV
ias_mask:
ENDIF
msk_mask:
	call	word ptr cs:[bx-4]
	mov	byte ptr cs:mask_act,al
	ret
ENDIF

;--- Misc. ---

	public	initvzkey,getkeytbl,setkey,setfnckey
IFDEF J31
	extrn	ctrl_froll	:near
setkey:
	cmp	al,KEY_DOS
	jne	setfnckey
	mov	al,OFF
	jmps	setkey1
setfnckey:
	mov	al,ON
setkey1:jmp	ctrl_froll
ELSE
setkey:
setfnckey:
ENDIF
initvzkey:
on_ezkey:
off_ezkey:
IFDEF IBM
	ret
getkeytbl:
	extrn	checkVM		:near
	call	is_dossilent
	jmp	checkVM
ELSE
getkeytbl:
	ret
ENDIF

	public	initkeytbl
initkeytbl proc
	clr	ax
	stosw
	stosw
	ret
initkeytbl endp


;--- ========================================================================

;--- Get keycode ---

bios_k2	macro	cmd			; ##156.87
	mov	ah,cmd
IFDEF JBM
	int	16h
ELSE
	call	bioskey
ENDIF
	endm



;idle1:	push	ax		; idle		##k06 =======================
;	int	28h
;	call	on_sleep
;;	call	time1
;	mov	ax,1680h
;	int	2fh
;;	cmp	al,80h
;;	jnz	idle2
;idle2:	pop	ax
;	ret

;csr_i2	dw,	0		; Ci
;csr_o2	dw,	0		; Co
csrblnk2	db	0		; 
GDATA idl_count,db,	0		; 
key_code	dw	0
fp_on		db	1


	public	idle5
idle5 proc
;idle5:
	pushall		;ax

	bios_k2	01h			; ah 01h  ; key check	int 16h
	jnz	idle98	;_e
IFDEF DOSV_BLINK
	mov	cl,2		;L[͒͏펞_
	mov	byte ptr cs:idl_count,cl		;L[͒͏펞_
;	call	blinkcsr
ENDIF
	test	cs:tvzsw,TSW_SLEEP	
;	test	byte ptr cs:hp_lx,2+4		;##k07j
	jz	idle27
	call	on_sleep
idle27:
;	mov	byte ptr cs:idl_count,1
idle28:
	cmp	byte ptr cs:had_err,1				;##k08i
	je	idle99
	int	28h
	mov	ax,1680h		; Win? & idle
	int	2fh
;	cmp	al,80h
;	jz	idle99
;		3 SYS_FILER   1 SYS_GETS   0 SYS_SEDIT   2 SYS_DOS 4 SYS_GETC

;	call	check_delay
;	cmp	sysmode,SYS_DOS	; 2
;	je	idle_s
idle_f:
	call	checkfkey
idle_s:
	call	shift_key		;ah=02h
idle7:
;	test	ah,KEY_SHIFT+KEY_ALT+KEY_CTRL
	test	ah,KEY_ALT
	jnz	idle99
idle8:
	cmp	opt_zpc,1			; oz1:dos key
	jnz	ozi0
IFDEF DOSV_BLINK
;	mov	ah,F_CONIO	;equ	06h	; Direct Console I/O
ELSE
;	mov	ah,F_CONIN	;equ	07h	; Direct Console Input
ENDIF
	msdos	F_CONIO
	mov	ah,al
	clr	al
	jmps	ozi1
ozi0:
	bios_k2	01h			; ah 01h  ; key check	int 16h
ozi1:
	jnz	idle98
idle9:
	cmp	sysmode,SYS_FILER	; 3
	jae	idle28
;	cmp	sysmode,SYS_SEDIT	; 0
;	jne	idle18
IFNDEF US
	cmp	byte ptr cs:csrblnk,0
;	jne	idle_e
	jne	idle998
ENDIF
;	cmp	word ptr cs:as_delay,0		;Qt
;	je	idle18
	cmp	byte ptr cs:idl_count,18
;;	ja	idle_e
	jae	idle999
idle18:
	add	byte ptr cs:idl_count,1		;ACh̓uN
;	jmp short	idle28
idle88:
IFDEF DOSV_BLINK
;	call	blinkcsr
ENDIF
	

	jmp short	idle27			;loop
idle98:
	mov	cs:key_code,ax

idle99:			;------ I ---------
	test	cs:tvzsw,TSW_SLEEP	
;	test	byte ptr cs:hp_lx,2+4		;HP+ ?
	jz	idle_e
	call	off_sleep			;LXX[vOFF
idle_e:
	mov	byte ptr cs:idl_count,1		;L[͒͏펞_
	mov	as_ringp,0		;Qn cler
idle998:
IFDEF DOSV_BLINK
;	mov	ah,byte ptr cs:csrblnk2
;	call	blinkcsr
ENDIF
idle999:
	popall	;ax
	ret
idle5 endp

; -----------------------------------------------------------------------

	public	getkeycode
getkeycode proc
IFDEF DOSV
	mov	di,INVALID
	call	vrestore
ENDIF
IFDEF DOSV_BLINK
	mov	bh,0
	bios_v	08h
	mov	cs:csrchr,ax		; ##157.150
ENDIF
	mov	ah,sysmode
	cmp	ah,SYS_FILER	;s3
_if ae				;ah>=s3  s3 s4---------
;  _if e
;	call	checkfkey
;  _endif
	call	wait_key
_else				;ah<s3  s0 s1 s2 ----------
	call	checkfp
	cmp	ah,SYS_SEDIT	;s0
  _if e				;s0 ----- ҏW[h ------
	push	ax
    _repeat
	call	check_delay
;	int	28h			; ##154.61
IFDEF DOSV_BLINK
	call	blinkcsr
ENDIF
;	call	checkfkey
	call	idle5			; s0 ҏW[h		##k06
	call	sense_key
    _while z
	cmp	al,SPC			; ##154.60
IFDEF US
    _if b
ELSE
    _if l
ENDIF
	tst	al
	pop	ax
	pushf				; ##156.87

	cmp	opt_zpc,1		; oz1  dos key
	jnz	oz0
IFDEF DOSV_BLINK
;	mov	ah,F_CONIO	;equ	06h	; Direct Console I/O
ELSE
;	mov	ah,F_CONIN	;equ	07h	; Direct Console Input
ENDIF
	msdos	F_CONIN
	mov	ah,al
	clr	al
	jmps	oz1
oz0:
	bios_k2	00h			;get-key
oz1:
	popf
      _ifn s
	call	waitkey1
      _endif
	jmps	gchar1
    _endif
	pop	ax
  _endif				; s0  END

	cmp	ah,SYS_DOS	;s2
IFDEF DOSV_BLINK
	mov	ah,F_CONIO	;equ	06h	; Direct Console I/O
ELSE
	mov	ah,F_CONIN	;equ	07h	; Direct Console Input
ENDIF
  _if e			; --------- s2 R}hC --------
	tstb	cs:cmdlinef
    _ifn z
	clr	bx
      _repeat
	call	check_delay
	call	idle5			;s2 R}hC	##k06
IFNDEF J31
	call	chkscreen		;##156.133
ENDIF
;	int	28h
IFDEF DOSV_BLINK
	call	blinkcsr
ENDIF
	msdos	F_IOCTRL,6	;equ	44h	; I/O Control for Devices
	tst	al
      _while z
IFDEF J31
	push	ax
	call	chkscreen		;##156.133
	pop	ax
ENDIF
	cmp	ah,03h			; CTRL-C
	mov	ah,F_CONIN		; 07h  Direct Console Input
      _if e
	mov	ah,F_READKEY	;equ	08h	; Read Keyboard
      _endif
    _endif
  _endif    			; s2 end
IFDEF DOSV_BLINK
	call	doswaitkey
ELSE
	int	21h
ENDIF
	clr	ah
	tst	al		;tst	al
  _if z
	msdos	F_CONIN
	mov	ah,al
	clr	al
  _endif
_endif
gchar1:	mov	dx,ax
	call	shift_key
        and	ah,KEY_SHIFT+KEY_ALT+KEY_CTRL
IFDEF JBM
	cmp	dx,0300h		; [CTRL]+[@]
	je	gctrl1
	cmp	dl,7Fh
	je	ctrl_bs
ELSE
	cmp	cs:key_code,735Ch	; [\_] = \ 	;##151120 k07s4
_if e
;	mov	dx,05Fh		;; _  5Fh		; ##151120
	mov	dx,05Ch					; \ = 5Ch
_endif
	cmp	cs:key_code,735Fh	; \[\_] = _ 	;##151120
_if e
	mov	dx,05Fh					; _ = 5Fh
_endif
	cmp	cs:key_code,731Ch	; ^[\_] = ^\	;##k07s4
_if e
;;;	mov	dx,01Fh					; ^_ = 1Fh
	mov	dx,01Ch					; ^\ = 1ch
_endif
	cmp	cs:key_code,73FFh	; @[\_] = @\	;##
_if e
	mov	dx,01Fh					; ^_ = 1Fh
_endif
;;	cmp	cs:key_code,73FFh	; ^@
;	cmp	dx,73FFh		; @_
;_if e
;	mov	dx,8200h		; @-
;_endif


	cmp	dl,0FFh			; ^@		;##k07s3
	jne	chk_key_e
	cmp	cs:key_code,1AFFh	; ^@
_if e
	mov	dx,0300h		; ^2
_endif
	cmp	cs:key_code,0DFFh	; ^^
_if e
	mov	dx,071Eh		; ^6
_endif
	cmp	dl,0FFh			; ^@
_if e
	xor	dx,dx			; nul
_endif
chk_key_e:
	mov	cs:key_code,0
	call	cvtspec2		; ##156.87
	jc	gcode8
ENDIF
	tst	dl
	jz	gspec1
	cmp	dl,SPC
	jb	gctrl1
	mov	ax,dx
	clr	dh
	call	iskanji
	jnc	gchar4
	mov	dh,dl
	tst	ah
_if z
	msdos	F_CONIN
_else
	mov	ah,00h			; ##157.151
IFNDEF JBM
	test	word ptr ss:extsw,ESW_FKEY
  _ifn z
	or	ah,10h
  _endif
ENDIF
	int	16h
_endif
gchar3:	mov	dl,al
gchar4:	clr	ax
	jmps	gcode9
gspec1:
	call	cvtspec
	jmps	gcode8
IFDEF JBM
ctrl_bs:
	mov	al,@CTR+@BS
	jmps	gcode8
ENDIF
gctrl1:
	call	cvtctrl
gcode8:	mov	ah,TRUE
	clc
gcode9:	ret
getkeycode endp


IFDEF DOSV_BLINK
doswaitkey proc
	cmp	ah,F_CONIO	;06
_ifn e
	int	21h
_else
  _repeat
	call	check_delay
	call	idle5			;s1 ͑		##k06
	call	blinkcsr
	mov	dl,0FFh
	msdos	F_CONIO
  _while z
_endif
	ret
doswaitkey endp
ENDIF

get_ringp	proc
		push	es
		clr	ax
		movseg	es,ax
		mov	ax,es:[ringp]
		pop	es
		ret
get_ringp 	endp

;--- Convert ctrl code ---
;-->
; DL :ctrl code (01h-20h)
; DH :scan code
; AH :shift status
;<--
; AL :key code

cvtctrl	proc
	mov	di,offset cgroup:tb_nkeycode
	mov	cx,NKEYCNT
	mov	al,dl
	call	scantbl
	jne	cvctr9
	sub	cl,NKEYCNT-1
	neg	cl
	test	ah,KEY_CTRL
IFDEF J31				; ##151.10
_ifn z
	cmp	dx,0E08h		; ##155.80
  _if e
	mov	al,@CTR+@BS
  _endif
	jmps	cvctr9
_endif
ELSE
	jnz	cvctr9
ENDIF
	mov	al,cl
	add	al,10011010b		; [ESC]
	test	ah,KEY_SHIFT
_ifn z
	or	al,@SFT
_endif
cvctr9:	clc
	ret
cvtctrl	endp

;--- Convert special key ---
;-->
; DH :scan code
; AH :shift status
;<--
; AL :key code
; CY :ignore

cvtspec	proc
	clr	al
	test	cs:tvzsw,TSW_NFER
_ifn z
	cmp	dh,XKEYMAX2
_else
	cmp	dh,XKEYMAX
_endif
	ja	cvspc9
	mov	al,dh
	sub	al,0Fh
	jc	cvspc9
	mov	bx,offset cgroup:tb_xkeycvt
	xlat	cs:tb_xkeycvt
IFDEF JBM
	call	cvtspec_func
ENDIF
	tst	al
	stc
	jz	cvspc9
_if s
	test	al,@ALT
  _if z
	test	ah,KEY_CTRL
    _ifn z
	or	al,@CTR
    _else
	test	ah,KEY_SHIFT
      _ifn z
	or	al,@SFT
      _endif
    _endif
  _endif
_else
	sub	al,20h
_endif
	clc
cvspc9:	ret	
cvtspec	endp

IFDEF JBM

; _@F11, _@F12, S@F11, S@F12, C@F11, C@F12, @ALT+@UP, @ALT+@DOWN 𔻕
cvtspec_func	proc
	cmp	al,S@F+1
_if z
	test	ah,KEY_SHIFT
  _if z
	mov	al,_@F+11
  _endif
_endif
	cmp	al,S@F+2
_if z
	test	ah,KEY_SHIFT
  _if z
	mov	al,_@F+12
  _endif
_endif
	cmp	al,C@F+1
_if z
	test	ah,KEY_CTRL
  _if z
	mov	al,S@F+11
  _endif
_endif
	cmp	al,C@F+2
_if z
	test	ah,KEY_CTRL
  _if z
	mov	al,S@F+12
  _endif
_endif
	cmp	al,A@F+1
_if z
	test	ah,KEY_ALT
  _if z
	mov	al,C@F+11
  _endif
_endif
	cmp	al,A@F+2
_if z
	test	ah,KEY_ALT
  _if z
	mov	al,C@F+12
  _endif
_endif
	cmp	al,@PGUP
_if z
	test	ah,KEY_ALT
  _ifn z
	mov	al,@ALT+@UP
  _endif
_endif
	cmp	al,@PGDN
_if z
	test	ah,KEY_ALT
  _ifn z
	mov	al,@ALT+@DOWN
  _endif
_endif
	ret
cvtspec_func	endp

ELSE

;--- Convert special key 2 ---		; ##156.87
;-->
; DX :scan code
;<--
; AL :key code (CY=1)

cvtspec2 proc
	push	es
	movseg	es,cs
	mov	di,offset cgroup:tb_xkeyscan
	mov	cx,(offset tb_xkeycode - offset tb_xkeyscan)/2
	push	ax
	mov	ax,dx
  repnz	scasw
	pop	ax
	clc
_if e
	sub	di,offset cgroup:tb_xkeyscan + 2
	shr	di,1
	add	di,offset cgroup:tb_xkeycode	;;
	mov	al,es:[di]			;;
	stc
_endif
	pop	es
	ret
cvtspec2 endp

ENDIF

;--- BIOS key function ---

IFNDEF JBM
bioskey	proc
	test	word ptr ss:extsw,ESW_FKEY	; ##153.29  fk
_if z
	int	16h
_else
	or	ah,10h
	int	16h
	pushf
	cmp	al,0E0h
_if e
	tst	ah
  _ifn z
	cmp	ah,0F0h			; ##157.151
    _if b
	clr	al
    _endif
  _endif
_endif
	popf
_endif
	ret
bioskey	endp
ENDIF

	public	wait_key,wait_key1			;L[̓C
wait_key1:
IFDEF DOSV
	mov	di,INVALID
	call	vrestore
ENDIF
wait_key proc
	push	bx
;	mov	ah,FEP_MASK
;	call	ctrlfp
_repeat
;	int	28h
	call	idle5			;s3 t@C[		##k06
	call	sense_key
_while z
	bios_k2	00h			;get-key
;;	mov	cs:key_code,ax
;	push	ax
;	mov	ah,FEP_ACT
;	call	ctrlfp
;	pop	ax
	pop	bx
waitkey1:
IFDEF J31
	cmp	ax,1A1Dh		; ctrl-[
_if e
	mov	ax,1A1Bh		; ctrl-\ ?
_endif
	cmp	ax,1B1Ch		; ctrl-]
_if e
	mov	ax,1B1Dh
_endif
ENDIF
IFDEF DOSV
;	cmp	ax,731Ch		; ^[\_] = ^\	; ##k07s4
;_if e
;	mov	ax,001Fh		; ^_
;_endif
;dosv_e:
ENDIF
IFDEF JBM
	cmp	ax,0F00h		; [SHIFT]+[TAB]
_if e
	mov	al,09h
_endif
ENDIF
IFDEF CVTKANA
	call	cvtkanakey
ENDIF
	ret
wait_key endp


	public	wait_key2
wait_key2 proc
	call	wait_key
	pushm	<bx,cx,si,di,ds>
	call	gchar1
	popm	<ds,di,si,cx,bx>
	ret

wait_key2 endp



	public	sense_key
sense_key proc
	bios_k2	01h			;chk-key
	ret

sense_key endp


	public	read_key
read_key proc
	call	sense_key
_ifn z
	bios_k2	00h			;get-key
	call	waitkey1
	tst	ax
_endif
	ret
read_key endp


	public	flush_key
flush_key proc
	push	ax
_repeat
	bios_k2	01h			; chk key
  _break z
	cmp	al,08			; bs? ##156.125
  _break e
	cmp	al,SPC			; al >= spc
  _break ae
	bios_k2	00h			; get key
_until
	pop	ax
	ret
flush_key endp


	public	shift_key
shift_key proc
	bios_k	02h			;get-sft
	test	al,2
_ifn z
	or	al,KEY_SHIFT
_endif
	mov	ah,al
	ret
shift_key endp


	public	beep_on
beep_on proc
IFDEF MG
        call    init_sound
_ifn c
        call    readparm
        mov     cx,dx
  _ifn cxz
        call    beep_mg
  _endif
	inc	sp
	inc	sp
	ret
_endif
ENDIF
	in	al,61h
	or	al,03h
	out	61h,al
	ret
beep_on endp


	public	beep_off
beep_off proc
	in	al,61h
	and	al,not 03h
	out	61h,al
	ret
beep_off endp


IFDEF MG

sounddrvID      db      '$SOUND',0
GDATA sound_func,dd,     INVALID

;---- init sounddrv.sys ----
;<-- CY = error

        public  init_sound
init_sound proc
        cmp     word ptr cs:sound_func,INVALID
        jnz     initsound_o
        pushm   <ds,bx,dx>
        movseg  ds,cs
        mov     dx,offset cgroup:sounddrvID
        msdos   F_OPEN,O_READ
_ifn c
        mov     bx,ax
	call	isdevice
  _ifn c
        push    es
        movseg  es,cs
        mov     cx,4                            ; cx = len
        mov     dx,offset cgroup:sound_func     ; es:dx = sounddrv API
        msdos   F_IOCTRL,2                      
        pop     es
        clc
  _endif
        pushf
        msdos   F_CLOSE 
        popf
_endif
        popm    <dx,bx,ds>
        ret
initsound_o:    
        clc
        ret
init_sound endp
;
;--- beep sounddrv ----
;--> cx = time

        public  beep_mg,mg_tone
beep_mg proc
        push    bx
        clr     dx
        mov     ax,cx
        mov     cx,3
        div     cx
        mov     cx,ax
        tst     dx
  _ifn z
        inc     cx
  _endif
mg_tone:mov     bx,1803                         ; bx:tone hz*119/100
        mov     ax,512                          ; ax:200h
        call    dword ptr cs:sound_func
        pop     bx
        ret
beep_mg endp

ENDIF



;--- Check Function key ---  ----------------------------------------------

checkfkey proc
IFDEF J31
	extrn	chkh	:byte		; ##156.123
	tstb	chkh
_if z
	mov	ax,0CFFh
	int	60h
	tst	al
	jnz	chkfk9
_endif
ENDIF
	cmp	byte ptr cs:msg_line2,255		;	##k08e
	je	chkfk9
;;	call	checkfp
;	test	fpmode,1		; mg.-9  bit0=1:off
;	jz	chkfk9
	cmp	sysmode,3		;	##k08e
	jne	chkfk0
	call	checkfp
	cmp	cs:fp_on,0	;?
	jz	chkfk9		;?
	cmp	sysmode,4		;	##k08e
	jae	chkfk9
chkfk0:
	tstb	dspkeyf					;	##k08a
	jnz	chkfk9
	call	shift_key
	mov	al,4
	test	ah,KEY_ALT
	jnz	chkfk1		;ah=alt
	mov	al,3
	test	ah,KEY_CTRL
	jnz	chkfk1
	mov	al,2
	test	ah,KEY_SHIFT
	jnz	chkfk1						;##k07e
	mov	al,1
chkfk1:	
	cmp	sysmode,SYS_SEDIT	;0edit			;##k08c
	je	chkfk3
	add	al,4			;5-8 s3filer
	cmp	sysmode,SYS_FILER				;##k07e
	je	chkfk2
	add	al,4			;9-12 s2dos
;	cmp	sysmode,SYS_DOS					;##k07i
	cmp	sysmode,1		;SYS_GETS	; ##K07r4
	je	chkfk2
	add	al,4			;13-16 s1gets
	cmp	sysmode,4		;SYS_GETC
	je	chkfk9
chkfk2:
	push	ax
	mov	ah,sysmode
	dec	al
;	test	al,byte ptr cs:omori_fkey		;	##k07i
	test	ax,cs:omori_fkey		;	##k07i
	pop	ax
	jz	chkfk9
;	call	clrfkey
;	call	newline
;	jmp	short chkfk9
chkfk3:	call	dispfkey
chkfk9:	ret
checkfkey endp

;--- Display function key ---
;-->
; AL :key mode (0=OFF 1=normal 2=shift 3=ctrl 4=alt 5>filer 9>DOS 13>input)

dispfkey proc
	cmp	al,fkeymode
	je	dspf9
dispfkey0:
	pushm	<bx,cx,dx,si,di>
	push	ax
	mov	al,ATR_FKEY	;no.17 15 ap
;	mov	al,byte ptr cs:fk_atr
	call	getatr
	mov	dl,al
	mov	al,ATR_DOS	;no.19 1 ae
	call	getatr
	mov	dh,al
	pop	ax
	push	ax
	tst	dl
	jz	dspf8
	tst	al
_if z
	mov	dl,dh
	clr	di
_else
	mov	di,fkeytbl
	cmp	sysmode,1		;SYS_GETS	; ##K07r4
	je	dspf0
;	inc	cl
	dec	al
dspf0:
	mov	ah,al
  _repeat
	cmp	byte ptr [di],-1
	je	dspf8
	tst	ah
    _break z
	mov	al,CR
;	mov	cx,-1			;
	mov	cx,7fffh		;##k 221011
  repne	scasb
	dec	ah
  _until
_endif
	pop	ax
	mov	fkeymode,al
	mov	si,di
	push	ax
	call	dispfkey1
dspf8:	pop	ax
	popm	<di,si,dx,cx,bx>
dspf9:	ret

;
dispfkey1:
	push	bp
	push	dx
	call	dosheight		;dos y
	mov	dh,ch			;ŉs
	clr	ch
	tstb	dspkeyf
_ifn z
	mov	dl,4
	call	mkscrnp
	pop	dx
_else
	clr	dl
	call	mkscrnp
	pop	dx
	mov	cl,4
	call	putspces
_endif
	mov	bp,offset cgroup:tb_fkeyspc10
	test	word ptr ss:extsw,ESW_FKEY		;fk
_ifn z
	mov	bp,offset cgroup:tb_fkeyspc12
_endif
	mov	bx,cs:[bp]
	inc	bp
	inc	bp
_repeat
	mov	cl,bh			; Fkey word size 5-6
  _repeat
	clr	ah
	tst	si
	jz	dspf1
	cmp	byte ptr [si],CR
	je	dspf1
	lodsb
	tst	al
    _if z
dspf1:
      _repeat
	mov	ax,SPC
	call	abputc1
      _loop
	jmps	dspf2
    _endif
	call	iskanji
    _if c
IFDEF J31
	mov	ah,al
	lodsb
	xchg	al,ah
ELSE
  IFDEF JBM
	mov	ah,al
	lodsb
	xchg	 al,ah
  ELSE
	call	abputc1
	lodsb
  ENDIF
ENDIF
;	cmp	sysmode,1		;SYS_GETS	; ##K07r4
;	je	dspf0
;	inc	cl
	dec	cx
;dspf0:
    _endif
	call	abputc1
  _loop
  _repeat
	lodsb
	tst	al
  _until z
dspf2:
	mov	cl,cs:[bp]
	inc	bp
	call	putspces
	dec	bl
_until z
	pop	bp
IFDEF DOSV
	call	vrefresh
ENDIF
	ret

putspces:
	xchg	dh,dl
	mov	ax,SPC
  _repeat
	call	abputc1
  _loop
	xchg	dh,dl
	public	sm_gettrgkey
sm_gettrgkey:
	ret
dispfkey endp


	assume	ds:nothing

;--- Check key ---			;X[XXN[L[
;<-- CY :break

	public	sm_chkkey
sm_chkkey proc
	call	read_key
	jz	sm_chksft
	cmp	al,SPC			; ##153.51
	je	chkk_p
	cmp	al,'.'
	jne	chkk3
chkk_p:	push	ax
	call	fep_mask	
	call	wait_key
	call	fep_act
	pop	cx
	cmp	al,cl
	je	sm_chksft
chkk3:	sub	al,'0'
	jb	chkk9
	cmp	al,8			; ##153.50
	ja	chkk9
	mov	rolc,al
	call	initrolc
chkk0:	clc
	ret
chkk9:	stc
	ret
sm_chkkey endp

;--- Check [SHIFT] key ---
;--> BH :init flag

	public	sm_chksft
sm_chksft proc
	call	shift_key
	tst	bh
_ifn z
	mov	sft,al
	jmps	chks1
_endif
	xor	al,sft
	test	al,KEY_SHIFT
_ifn z
	xor	sft,KEY_SHIFT
chks1:
	mov	al,rolc
	test	ah,KEY_SHIFT
  _ifn z
	cmp	al,4
    _if e
	mov	al,3
    _else
	mov	al,4
    _endif
  _endif
	call	initrolc
_endif
	clc
	ret
sm_chksft endp

;--- Is DBCS mode? ---

	public	isDBCS
isDBCS proc
IFDEF US
	add	sp,2
	clc
ELSE
  IFDEF IBM
	extrn	dbcs		:byte
	tstb	dbcs
_if z
	add	sp,2
	clc
_endif
  ENDIF
ENDIF
	ret
isDBCS endp

;---- HP 95/100/200 Light Sleep ----

sleep	db	INVALID		;-1

	public off_sleep, on_sleep
off_sleep proc
	test	cs:tvzsw,TSW_SLEEP	
;	test	byte ptr cs:hp_lx,1+2+4					;##k07j
_ifn z
	cmp	cs:sleep,INVALID	;-1
  _if z
	pushm	<es,ax>
	clr	ax
	mov	es,ax
	test	byte ptr es:[04D6h],01
    _if z
	mov	cs:sleep,al
	mov	ax,4E00h				;hplx
	int	15h
    _endif
	popm	<ax,es>
  _endif
_endif
	ret
off_sleep endp

on_sleep proc
	push	ax
;	push	bx		;
	mov	al,INVALID		;-1
	xchg	al,cs:sleep
	test	cs:tvzsw,TSW_SLEEP	
;	test	byte ptr cs:hp_lx,1+2+4	
_ifn z
	cmp	al,INVALID		;-1
  _ifn z
	mov	ax,4E01h
	int	15h
;	mov	bx,cs:hp_lx	;199Ah=6min 0CCDh=3min power off
;	cmp	bh,4		;$1993      $cc3 $1093=1min
;	jb	on_s99
;	mov	ah,46h
;	int	15h
on_s99:
  _endif
_endif
;	pop	bx		;
	pop	ax
	ret
on_sleep  endp

	endhs

;****************************
;	End of 'keyIBM.asm'
; Copyright (C) 1989 by c.mos
; arranged by H.Takahashi
;****************************
