#include	"compiler.h"
#include	<gx.h>
#if defined(W03_2)
//#include <windows.h>
//#include <Afxwin.h>
#endif
//#if !defined(GX_DLL)
//#include	"gx.h"
//#endif
#include	"bmpdata.h"
#include	"scrnmng.h"
#include	"scrndraw.h"
#include	"vramhdl.h"
#include	"menubase.h"
#include	"nekop2.res"
#include	"cmndraw.h"
#include	"softkbd.h"
#include	"winkbd.h"
// #include	"ini.h"


#if defined(GX_DLL)
#pragma comment(lib, "gx.lib")
#endif


typedef struct {
	BOOL	rotate;
	VRAMHDL	vram;
	UINT	posx;
	UINT	posy;
	int		width;
	int		height;
	long	start;
	long	xalign;
	long	yalign;
#if defined(SUPPORT_SOFTKBD)
	int		kbdposy;
	int		kbdheight;
	int		allflash;
#endif
	int		mode;
} SCRNMNG;

typedef struct {
	int		width;
	int		height;
} SCRNSTAT;

	GXDisplayProperties		gx_dp;

static	SCRNMNG		scrnmng;
static	SCRNSTAT	scrnstat;
static	SCRNSURF	scrnsurf;

static	UINT8		gx_disable = 1;
extern	GXKeyList	gx_keylist;
static	int		scr_w;
static	int		scr_h;
extern	int	screen_mode;
//#if defined(W03_2)
extern	int psp_scrn_mode;
//static int psp_scrn_mode;
//#endif

static const TCHAR	errmsg[] = _T("Error");


typedef struct {
	int		xalign;
	int		yalign;
	int		width;
	int		height;
	int		srcpos;
	int		dstpos;
} DRAWRECT;


// ---- GX DLLƂ

#if !defined(WIN32_PLATFORM_PSPC) || !defined(SIZE_VGA)

#define	GXGETDISPLAYPROPERTIES()	GXGetDisplayProperties()
#define	GXBEGINDRAW()				GXBeginDraw()
#define	GXENDDRAW()					GXEndDraw()

#else // PocketPC2003SE VGA

typedef struct {
	WORD	wFormat;
	WORD	wBPP;
	VOID	*pFramePointer;
	int		cxStride;
	int		cyStride;
	int		cxPixels;
	int		cyPixels;
} RAWFRAMEBUFFERINFO;

#define	GETRAWFRAMEBUFFER	0x00020001

enum {
	RFBIFMT_565		= 1,
	RFBIFMT_555		= 2,
	RFBIFMT_OTHER	= 3
};

static	RAWFRAMEBUFFERINFO	rfbi;

static GXDisplayProperties GXGETDISPLAYPROPERTIES(void) {

	HDC					hdc;
	GXDisplayProperties	ret;

	hdc = GetDC(NULL);
	ExtEscape(hdc, GETRAWFRAMEBUFFER, 0, NULL, sizeof(rfbi), (char *)&rfbi);
	ReleaseDC(NULL, hdc);
	ret.cxWidth = rfbi.cxPixels;
	ret.cyHeight = rfbi.cyPixels;
	ret.cbxPitch = rfbi.cxStride;
	ret.cbyPitch = rfbi.cyStride;
	ret.cBPP = rfbi.wBPP;
	ret.ffFormat = 0;
	switch(rfbi.wFormat) {
		case RFBIFMT_565:
			ret.ffFormat |= kfDirect565;
			break;

		case RFBIFMT_555:
			ret.ffFormat |= kfDirect555;
			break;
	}
	return(ret);
}
#define	GXBEGINDRAW()		(rfbi.pFramePointer)
#define	GXENDDRAW()
#endif

//#define	RESIZE

#if defined(PPP) || defined(W03_3) || defined(SIZE_QVGA)
static int	WINDOW_WIDTH = 320;
static int	WINDOW_HEIGHT = 240;
static int	g_i = 2;	
//static int	np2cfg.skipline;
#elif defined(SIZE_HVGA)
static int	WINDOW_WIDTH = 640;	
static int	WINDOW_HEIGHT = 240;	
static int	g_i = 2;	
#elif defined(SIZE_400)
static int	WINDOW_WIDTH = 400;	
static int	WINDOW_HEIGHT = 240;	
static int	g_i = 2;	
#elif defined(A55) || defined(SIZE_480)
static int	WINDOW_WIDTH = 480;	
static int	WINDOW_HEIGHT = 240;	
static int	g_i = 2;	
#else
static int	WINDOW_WIDTH = 640;
static int	WINDOW_HEIGHT = 480;
static int	g_i = 1;	
//static int	np2cfg.skipline;
#endif
static int	SURFACE_WIDTH2 = WINDOW_WIDTH;
static int	SURFACE_HEIGHT2 = WINDOW_HEIGHT;

	GXDisplayProperties	gd;
	HWND			gxhwnd;
	HBITMAP			hgxbmp;
	int				GXStartX;
	int				GXStartY;
	HDC		hdc;
	HDC		hmemdc;
	HBITMAP	hbitmap;



#if defined(RESIZE)
int CXEndDraw(void) {

	gd.cxWidth = WINDOW_WIDTH;
	gd.cyHeight = WINDOW_HEIGHT;
	int	i = 0;
	int	j = 0; //GXStartY;
	int jj = 240; //gd.cyHeight /8;

	if (gxhwnd) {
		hdc = GetDC(gxhwnd);
		hmemdc = CreateCompatibleDC(hdc);
		hbitmap = (HBITMAP)SelectObject(hmemdc, hgxbmp);

//	  if (psp_scrn_mode != 3) {
		for (i=0; i < jj; i++) {
		  BitBlt(hdc, GXStartX, GXStartY+j, gd.cxWidth, 1, hmemdc, 0, i, SRCCOPY);
		  j=i+1;
		  BitBlt(hdc, GXStartX, GXStartY+j, gd.cxWidth, 1, hmemdc, 0, i, SRCCOPY);
		  j++;
		  
		}
//	  } else {
//		BitBlt(hdc, GXStartX, GXStartY, gd.cxWidth, gd.cyHeight,
//				hmemdc, 0, 0, SRCCOPY); // m[}\
//	  }
		SelectObject(hmemdc, hbitmap);
		DeleteDC(hmemdc);
		ReleaseDC(gxhwnd, hdc);
	}
	return(1);
}
#endif



#if defined(W03_2)
void scrnmng_change_scrn(INT scrn_mode)
//void scrnmng_change_scrn(UINT8 scrn_mode)
{
//INT scrn_mode;
int	WINDOW_WIDTH;	
int	WINDOW_HEIGHT;	
	DWORD	x;
	DWORD	y;
    psp_scrn_mode = (int)scrn_mode;

    if (psp_scrn_mode == 0) {			//0
//#if defined(PPP) || defined(W03_3) || defined(SIZE_QVGA)
#if defined(PPP) || defined(W03_3) 
    x = 320 , y = 240 ;
    g_i = 1;
	WINDOW_WIDTH	= 320;	
	WINDOW_HEIGHT	= 240;	
#elif defined(SIZE_HVGA)
    x = 640 , y = 240 ;
    g_i = 1;
	WINDOW_WIDTH	= 640;	
	WINDOW_HEIGHT	= 240;	
#elif defined(SIZE_400)
    x = 400 , y = 240 ;
    g_i = 1;
	WINDOW_WIDTH	= 400;	
	WINDOW_HEIGHT	= 240;	
#elif defined(A55) || defined(SIZE_480)
    x = 480 , y = 240 ;
    g_i = 1;
	WINDOW_WIDTH	= 480;	
	WINDOW_HEIGHT	= 240;	
#else
    x = 640 , y = 480 ;
    g_i = 1;
	WINDOW_WIDTH	= 640;	
	WINDOW_HEIGHT	= 480;	
#endif

    }else if (psp_scrn_mode == 1) {		//180
#if defined(PPP) || defined(W03_3) || defined(SIZE_QVGA)
//#if defined(PPP) || defined(W03_3)
    x = 320 , y = 240 ;
    g_i = 1;
	WINDOW_WIDTH	= 320;	
	WINDOW_HEIGHT	= 240;	
#else
    x = 640 , y = 480 ;
    g_i = 1;
	WINDOW_WIDTH	= 640;	
	WINDOW_HEIGHT	= 480;	
#endif

    }else if (psp_scrn_mode == 3) {		//90 480*480
    x = 480 , y = 480 ;
    g_i = 1;
	WINDOW_WIDTH	= 480;	
	WINDOW_HEIGHT	= 480;	

    }else {
//  if (psp_scrn_mode == 3) {			//90 480*480
#if defined(PPP) || defined(W03_3) || defined(SIZE_QVGA)
//#if defined(PPP) || defined(W03_3)
    x = 320 , y = 240 ;
    g_i = 1;
	WINDOW_WIDTH	= 320;	
	WINDOW_HEIGHT	= 240;	
#else
    x = 640 , y = 480 ;
    g_i = 1;
	WINDOW_WIDTH	= 640;	
	WINDOW_HEIGHT	= 480;	
#endif
    }

	GXCloseDisplay();
//    scrnmng.mode = psp_scrn_mode;
	scrnstat.width = WINDOW_WIDTH;	
	scrnstat.height = WINDOW_HEIGHT;	
	SURFACE_WIDTH2 = x;	
	SURFACE_HEIGHT2 = y;	
//	GXCloseDisplay();
//	scrnmng_clear(0);
	scrnmng_create(0,WINDOW_WIDTH, WINDOW_HEIGHT);
#if defined(WIN32_PLATFORM_PSPC)
//	winkbd_bindinit();
#endif
#if defined(W03)
//scrnmng_keybinds();				////
#endif
}
#endif





// ----

static BOOL calcdrawrect(DRAWRECT *dr, VRAMHDL s, const RECT_T *rt) {

	int		pos;

	dr->xalign = scrnmng.xalign;
	dr->yalign = scrnmng.yalign;
	dr->srcpos = 0;
	dr->dstpos = scrnmng.start;
	dr->width = min(scrnmng.width, s->width);
	dr->height = min(scrnmng.height, s->height);
	if (rt) {
		pos = max(rt->left, 0);
		dr->srcpos += pos;
		dr->dstpos += pos * dr->xalign;
		dr->width = min(rt->right, dr->width) - pos;

		pos = max(rt->top, 0);
		dr->srcpos += pos * s->width;
		dr->dstpos += pos * dr->yalign;
		dr->height = min(rt->bottom, dr->height) - pos;
	}
	if ((dr->width <= 0) || (dr->height <= 0)) {
			MessageBox(0, _T("calc ?? ..."),
			errmsg, MB_OK | MB_ICONSTOP);
		return(FAILURE);
	}
	return(SUCCESS);
}



static void palcnv(CMNPAL *dst, const RGB32 *src, UINT pals, UINT bpp) {

	UINT	i;

	if (bpp == 16) {
		for (i=0; i<pals; i++) {
			dst[i].pal16 = ((src[i].p.r & 0xf8) << 8) |
							((src[i].p.g & 0xfc) << 3) |
							(src[i].p.b >> 3);
		}
	}
}



static void bmp16draw(void *bmp, UINT8 *dst, int width, int height,
												int xalign, int yalign) {

	CMNVRAM	vram;

	vram.ptr = dst;
#if defined(PPP)
	vram.width = width / 2;
#else
	vram.width = width;
#endif
	vram.height = height;
	vram.xalign = xalign;
	vram.yalign = yalign;
	vram.bpp = 16;
	cmndraw_bmp16(&vram, bmp, palcnv, CMNBMP_CENTER | CMNBMP_MIDDLE);
//	vram.width = width;
}



// ----

void scrnmng_initialize(void) {

//#if defined(W03_3)
#if defined(W03_3) // || defined(SIZE_QVGA)		//40*15
	scrnstat.width = 320;
	scrnstat.height = 240;
#elif defined(PPP)
	scrnstat.width = 640; //* PPP usei -- speed up (z`GA?)
	scrnstat.height = 240; //* PPP usei -- speed up (z`GA?)
#elif defined(SIZE_VGAH)	//80*15
	scrnstat.width = 640;
	scrnstat.height = 240;
#elif defined(A55) || defined(SIZE_480)
	scrnstat.width = 480;
	scrnstat.height = 240;
#else
	scrnstat.width = 640; //640;
	scrnstat.height = 480; //400;
#endif
}



BOOL scrnmng_create(HWND hWnd, LONG width, LONG height) {

	TCHAR	msg[32];
#if defined(SUPPORT_SOFTKBD)
	int		kbdheight;
#endif

	if ((width <= 0) || (height <= 0)) {
		wsprintf(msg, _T("??? w%d x h%d..."), width, height);
		MessageBox(hWnd, msg, errmsg, MB_OK | MB_ICONSTOP);
		return(FAILURE);
	}
	if (GXOpenDisplay(hWnd, GX_FULLSCREEN) == 0) {
		MessageBox(hWnd, _T("Couldn't GAPI Object"),
											errmsg, MB_OK | MB_ICONSTOP);
		return(FAILURE);
	}
	gx_dp = GXGETDISPLAYPROPERTIES();
	if (gx_dp.cBPP != 16) {
		MessageBox(hWnd, _T("Only 16bit color support..."),
											errmsg, MB_OK | MB_ICONSTOP);
		return(FAILURE);
	}
	if (!(gx_dp.ffFormat & kfDirect565)) {
		MessageBox(hWnd, _T("Only 16bit(565) support..."),
											errmsg, MB_OK | MB_ICONSTOP);
		return(FAILURE);
	}

	if ((gx_dp.cxWidth >= (DWORD)width) &&
		(gx_dp.cyHeight >= (DWORD)height)) {
//071201    	if (psp_scrn_mode != 3) {
			scrnmng.rotate = FALSE;		// 0?
//071201		}
	}
//		ʉ]L W03ԁH--------
	else if ((gx_dp.cxWidth >= (DWORD)height) &&
			(gx_dp.cyHeight >= (DWORD)width)) {
		scrnmng.rotate = TRUE;		// 1?
	}
	else {	//if (psp_scrn_mode == 0) {
		wsprintf(msg, _T("Required w%d x h%d..."), width, height);
		MessageBox(hWnd, msg, errmsg, MB_OK | MB_ICONSTOP);
		return(FAILURE);
	}

#if defined(W03_2)
//		ʔ] 180  mode1 --------------
    if (psp_scrn_mode == 1) {
		scrnmng.posx = ((gx_dp.cxWidth - height) / 2);
		scrnmng.posy = ((gx_dp.cyHeight - width) / 2);
		scrnmng.start = ((scrnmng.posy ) * gx_dp.cbyPitch) +	//rev
						((scrnmng.posx + height - 1) * gx_dp.cbxPitch);	//rev
		scrnmng.width = width;
		scrnmng.height = height;
		scrnmng.xalign = gx_dp.cbyPitch;	//rev
		scrnmng.yalign = -gx_dp.cbxPitch;	//rev
	}
//		ʉ] 0 320*240 mode2 --------------
//	else if (!scrnmng.rotate || psp_scrn_mode == 2 ) {
	else if ( psp_scrn_mode == 3 ) {
#else
	if (!scrnmng.rotate && psp_scrn_mode == 0 ) {
//	if (!scrnmng.rotate || psp_scrn_mode == 2 ) {
//	if (!scrnmng.rotate ) {
#endif
		scrnmng.posx = ((gx_dp.cxWidth - width) / 2);
//#if defined(SIZE_HVGA)		// ========== h.k
		scrnmng.posy = (0);			//H.K
//#else
//		scrnmng.posy = ((gx_dp.cyHeight - height) / 2);
//#endif
		scrnmng.start = scrnmng.posx * gx_dp.cbxPitch +
						scrnmng.posy * gx_dp.cbyPitch;
		scrnmng.width = width;
#if defined(SIZE_VGAH)		// ======== h.k
		scrnmng.height = (height/2);	//H.K
#else
		scrnmng.height = height;
#endif
		scrnmng.xalign = gx_dp.cbxPitch;
		scrnmng.yalign = gx_dp.cbyPitch;
	}
#if 0		// ---------------------
//	else if (scrnmng.rotate && psp_scrn_mode == 0 ) {
	else if (!scrnmng.rotate && psp_scrn_mode == 0 ) {
		scrnmng.posx = ((gx_dp.cxWidth - width) / 2);
		scrnmng.posy = ((gx_dp.cyHeight - height) / 2);
		scrnmng.start = scrnmng.posx * gx_dp.cbxPitch +
						scrnmng.posy * gx_dp.cbyPitch;
		scrnmng.width = width;
		scrnmng.height = height;
		scrnmng.xalign = gx_dp.cbxPitch;
		scrnmng.yalign = gx_dp.cbyPitch;
	}
#endif
//#if !defined(PPP)
//		ʉ] 90  mode3 --------------
	else {
		scrnmng.posx = ((gx_dp.cxWidth - height) / 2);
		scrnmng.posy = ((gx_dp.cyHeight - width) / 2);
		scrnmng.start = ((scrnmng.posy + width - 1) * gx_dp.cbyPitch) +
						(scrnmng.posx * gx_dp.cbxPitch);
		scrnmng.width = width;					/////////////////////
		scrnmng.height = height;
		scrnmng.xalign = -gx_dp.cbyPitch;
		scrnmng.yalign = gx_dp.cbxPitch;

	}
//#endif
	gx_disable = 0;
	scrnmng_clear(TRUE);
//	scrnmng_clear(0);
#if defined(SUPPORT_SOFTKBD)
//    if (psp_scrn_mode == 2) {
	softkbd_initialize();
	if (softkbd_getsize(NULL, &kbdheight) != SUCCESS) {
		kbdheight = 0;
	}
	kbdheight = min(kbdheight, height);
	scrnmng.kbdposy = height - kbdheight;
	scrnmng.kbdheight = kbdheight;
//	}
#endif
//scrnmng_keybinds();
	return(SUCCESS);
}



void scrnmng_destroy(void) {

	gx_disable = 1;
	GXCloseDisplay();
#if defined(SUPPORT_SOFTKBD)
	softkbd_deinitialize();
#endif
}

#if defined(SUPPORT_SOFTKBD)
void scrnmng_allflash(void) {

	scrnmng.allflash = 1;
}
#endif

RGB16 scrnmng_makepal16(RGB32 pal32) {

	RGB16	ret;

	ret = (pal32.p.r & 0xf8) << 8;
//#if defined(SIZE_QVGA) && !defined(SIZE_VGATEST)
#if defined(SIZE_QVGA)
	ret += (pal32.p.g & 0xfc) << (3 + 16);
//#elif defined(W03_3)
//	ret += (pal32.p.g & 0xfc) << (3 + 16);
#else
	ret += (pal32.p.g & 0xfc) << 3;
#endif
	ret += pal32.p.b >> 3;
	return(ret);
}

void scrnmng_setwidth(int posx, int width) {

	scrnstat.width = width;
}

void scrnmng_setheight(int posy, int height) {

	scrnstat.height = height;
}

const SCRNSURF *scrnmng_surflock(void) {

	if (gx_disable) {
		return(NULL);
	}
	if (scrnmng.vram == NULL) {
		scrnsurf.ptr = (UINT8 *)GXBEGINDRAW() + scrnmng.start;
		scrnsurf.xalign = scrnmng.xalign;
		scrnsurf.yalign = scrnmng.yalign;
	}
	else {
		scrnsurf.ptr = scrnmng.vram->ptr;
		scrnsurf.xalign = 2;
		scrnsurf.yalign = scrnmng.vram->yalign;
	}

#if defined(W03_3)		//40*15
	scrnsurf.width = min(scrnstat.width, 320);	//640
	scrnsurf.height = min(scrnstat.height, 240);	//400  
#elif defined(PPP)		//40*15
	scrnsurf.width = min(scrnstat.width, 640);		//320 ؂ւł640
	scrnsurf.height = min(scrnstat.height, 240);	//200
//#elif defined(SIZE_QVGA)
//	scrnsurf.width = min(scrnstat.width, 320);		//640
//	scrnsurf.height = min(scrnstat.height, 240);	//400
#elif defined(A55) || defined(SIZE_480)
	scrnsurf.width = min(scrnstat.width, 480);
	scrnsurf.height = min(scrnstat.height, 240);	//200
#elif defined(SIZE_HVGA)
	scrnsurf.width = min(scrnstat.width, 640);		//640
	scrnsurf.height = min(scrnstat.height, 240);	//400
#else
	scrnsurf.width = min(scrnstat.width, 640);		//VGA
	scrnsurf.height = min(scrnstat.height, 480);
#endif
	scrnsurf.bpp = 16;
	scrnsurf.extend = 0;
	return(&scrnsurf);
}

static void draw_onmenu(void) {

	RECT_T		rt;
	DRAWRECT	dr;
const UINT8		*p;
	UINT8		*q;
const UINT8		*a;
	int			salign;
	int			dalign;
	int			r;

	rt.left = 0;
	rt.top = 0;
#if defined(SUPPORT_SOFTKBD)
	if (!scrnmng.allflash) {
#endif
#if defined(W03_3)
		rt.right = min(scrnstat.width, 320);
		rt.bottom = min(scrnstat.height, 240);
#elif defined(PPP)
//		rt.right = min(scrnstat.width, 320);	//640
		rt.right =  320;	//640
		rt.bottom = min(scrnstat.height, 240);
#elif defined(A55) || defined(SIZE_480)
		rt.right = min(scrnstat.width, 480);	//
		rt.bottom = min(scrnstat.height, 240);	//
#else
		rt.right = min(scrnstat.width, 640);	//640
		rt.bottom = min(scrnstat.height, 480);	//400
#endif
//#if defined(SIZE_HVGA)
#if defined(W03_H) || defined(W03_3)
		rt.bottom >>= 2;
//#elif defined(SIZE_QVGA) || defined(W03_3)
#elif defined(SIZE_QVGA) 
		rt.right >>= 1;
		rt.bottom >>= 1;
#endif
#if defined(SUPPORT_SOFTKBD)
	}
	else {
		scrnmng.allflash = 0;
		rt.right = scrnmng.width;
		rt.bottom = scrnmng.height;
//		rt.right = min(scrnstat.width, 640);	//640
//		rt.bottom = min(scrnstat.height, 480);	//400
	}
#endif
	if (calcdrawrect(&dr, menuvram, &rt) != SUCCESS) {
		return;
	}
	p = scrnmng.vram->ptr + (dr.srcpos * 2);
	q = (UINT8 *)GXBEGINDRAW() + dr.dstpos;
	a = menuvram->alpha + dr.srcpos;
	salign = menuvram->width - dr.width;
	dalign = dr.yalign - (dr.width * dr.xalign);
	do {
		r = dr.width;
		do {
			if (a[0] == 0) {
				*(UINT16 *)q = *(UINT16 *)p;
			}
			p += 2;
			q += dr.xalign;
			a += 1;
		} while(--r);
		p += salign * 2;
		q += dalign;
		a += salign;
	} while(--dr.height);
//	GXENDDRAW();
#if defined(RESIZE)
			CXEndDraw();
#else
			GXENDDRAW();
#endif
}



void scrnmng_surfunlock(const SCRNSURF *surf) {

#if defined(SUPPORT_SOFTKBD)
	CMNVRAM	vram;
#endif

	if (surf) {
		if (scrnmng.vram == NULL) {
#if defined(SUPPORT_SOFTKBD)
//    if (psp_scrn_mode == 2) {
			if (scrnmng.allflash) {
				scrnmng.allflash = 0;
				vram.ptr = surf->ptr + (scrnmng.kbdposy * surf->yalign);
				vram.width = scrnmng.width;
				vram.height = scrnmng.kbdheight;
				vram.xalign = surf->xalign;
				vram.yalign = surf->yalign;
				vram.bpp = 16;
				softkbd_paint(&vram, palcnv, TRUE);
			}
//	}
#endif
#if defined(RESIZE)
			CXEndDraw();
#else
			GXENDDRAW();
#endif
		}
		else {
			if (menuvram) {
#if defined(PPP)
	scrnstat.width = 320;		//???
#endif
				draw_onmenu();
			}
		}
	}
}



// ---- for wince

void scrnmng_enable(BOOL enable) {

	if (enable) {
		gx_disable &= ~2;
	}
	else {
		gx_disable |= 2;
	}
}

BOOL scrnmng_mousepos(LPARAM *lp) {

	DWORD	sx;
	DWORD	sy;
	UINT	x;
	UINT	y;

#if defined(NO_SC)
	sx = WINDOW_WIDTH;
	sy = WINDOW_HEIGHT;
#else
	sx = GetSystemMetrics(SM_CXSCREEN);		// W03 ]̃j[}EXΉ
	sy = GetSystemMetrics(SM_CYSCREEN);
#endif
#if defined(W03_2)
    if (psp_scrn_mode == 1 && sx >= sy ) {				//1  180.0
		x = scrnmng.width - LOWORD(*lp) - 1 - scrnmng.posx;
		y = scrnmng.height - HIWORD(*lp) - 1 - scrnmng.posy;
	}
    else if ((psp_scrn_mode == 1 && sx <= sy )			//1  180.90
		) {
#if defined(MOUSE_3)
		x = ( HIWORD(*lp) - scrnmng.posy ) /2 ;
		y = scrnmng.height - ( LOWORD(*lp) - 1 - scrnmng.posx ) / 2 ;
#else
		x = HIWORD(*lp) - scrnmng.posy;
		y = scrnmng.height - LOWORD(*lp) - 1 - scrnmng.posx;
#endif
	}
    else if (psp_scrn_mode == 2 && sx >= sy ) {			//2  90.0
		y = scrnmng.height - LOWORD(*lp) + 80;			//???
		x = HIWORD(*lp) - scrnmng.posx;
	}
    else if ((psp_scrn_mode == 2 && sx <= sy )			//2  90.90
			|| psp_scrn_mode == 3 || (sx >= sy )) {		//3  0.0
		x = LOWORD(*lp) - scrnmng.posx;
		y = HIWORD(*lp) - scrnmng.posy;
	}
	else if ( sx >= sy ) {								//0  0.0
		x = LOWORD(*lp) - scrnmng.posx;
		y = HIWORD(*lp) - scrnmng.posy;
	}
	else {												//0  0.90
#if defined(MOUSE_3)
	  x = scrnmng.width - ( HIWORD(*lp) - scrnmng.posy ) / 2 ;
		y = ( LOWORD(*lp) - scrnmng.posx ) / 2;
#else
		x = scrnmng.width - HIWORD(*lp) - 1 - scrnmng.posy;
		y = LOWORD(*lp) - scrnmng.posx;
#endif
	}

#else
	if ( sx >= sy ) {								// 0.0
		x = LOWORD(*lp) - scrnmng.posx;
		y = HIWORD(*lp) - scrnmng.posy;
	}
	else {											// 0.90
		x = scrnmng.width - HIWORD(*lp) - 1 - scrnmng.posy;
		y = LOWORD(*lp) - scrnmng.posx;
	}
#endif
//	if ((x >= (UINT)scrnmng.width) || (y >= (UINT)scrnmng.height)) {
//		return(FAILURE);
//	}
	if (x >= (UINT)scrnmng.width) {
	  x = (UINT)scrnmng.width;
//	if (x >= (DWORD)sx) {
//	  x = (DWORD)sx;
	}
	if  (y >= (UINT)scrnmng.height) {
	  y = (UINT)scrnmng.height;
//	if (x >= (DWORD)sy) {
//	  x = (DWORD)sy;
	}
	*lp = (x & 0xffff) | ((y << 16) & 0xffff0000);
	return(SUCCESS);
}

void scrnmng_clear(BOOL logo) {

	void	*bmp;
	UINT8	*p;
	UINT8	*q;
	int		y;
	int		x;
	long	yalign;

	if (gx_disable) {
		return;
	}
	bmp = NULL;
	if (logo) {
		bmp = (void *)bmpdata_solvedata(nekop2_bmp);
	}
	p = (UINT8 *)GXBEGINDRAW();
	q = p;
	y = gx_dp.cyHeight;
	yalign = gx_dp.cbyPitch - (gx_dp.cbxPitch * gx_dp.cxWidth);
	do {
		x = gx_dp.cxWidth;
		do {
			*(UINT16 *)q = 0;
			q += gx_dp.cbxPitch;
		} while(--x);
		q += yalign;
	} while(--y);
#if defined(PPP0)
	bmp16draw(bmp, p + scrnmng.start, scrnmng.width / 2, scrnmng.height,
						scrnmng.xalign, scrnmng.yalign);
//						GXENDDRAW();
#if defined(RESIZE)
			CXEndDraw();
#else
			GXENDDRAW();
#endif
#else
#if defined(SIZE_VGAH)
	bmp16draw(bmp, p + scrnmng.start, scrnmng.width, scrnmng.height /2,
						scrnmng.xalign, scrnmng.yalign);
#else
	bmp16draw(bmp, p + scrnmng.start, scrnmng.width, scrnmng.height,
						scrnmng.xalign, scrnmng.yalign);
#endif
//						GXENDDRAW();
#if defined(RESIZE)
			CXEndDraw();
#else
			GXENDDRAW();
#endif
#endif
	if (bmp) {
		_MFREE(bmp);
	}
}

#if 1
void scrnmng_keybinds(void) {

	short	tmp;

	if (scrnmng.rotate) {
		tmp = gx_keylist.vkLeft;
		gx_keylist.vkLeft = gx_keylist.vkDown;
		gx_keylist.vkDown = gx_keylist.vkRight;
		gx_keylist.vkRight = gx_keylist.vkUp;
		gx_keylist.vkUp = tmp;
	}
}
#endif

#if 0
void scrnmng_keybinds3(void) {

	DWORD	sx;
	DWORD	sy;
	short	tmp_left  = 0x3a;		// 0x3b 3a
	short	tmp_down  = 0x3b;		// 0x3d 3b
	short	tmp_up    = 0x3c;		// 0x3a 3c
	short	tmp_right = 0x3d;		// 0x3c 3d
	sx = GetSystemMetrics(SM_CXSCREEN);
	sy = GetSystemMetrics(SM_CYSCREEN);
	 if ( psp_scrn_mode == 3 && sx > sy)  {	// 180.90
		gx_keylist.vkLeft = tmp_left;
		gx_keylist.vkUp = tmp_up;
		gx_keylist.vkRight = tmp_right;
		gx_keylist.vkDown = tmp_down;
	} else if ( psp_scrn_mode == 3 && sx < sy)  {	// 180.90 rand
		gx_keylist.vkLeft = tmp_right;
		gx_keylist.vkUp = tmp_down;
		gx_keylist.vkRight = tmp_left;
		gx_keylist.vkDown = tmp_up;
	} else if (psp_scrn_mode <= 2 && sx < sy) {		// 0.90 
		gx_keylist.vkLeft = tmp_up;
		gx_keylist.vkDown = tmp_left;
		gx_keylist.vkRight = tmp_down;
		gx_keylist.vkUp = tmp_right;
	} else {										// 0.0
		gx_keylist.vkLeft = tmp_down;
		gx_keylist.vkDown = tmp_right;
		gx_keylist.vkRight = tmp_up;
		gx_keylist.vkUp = tmp_left;
//		gx_keylist.vkLeft = tmp_left;
//		gx_keylist.vkUp = tmp_up;
//		gx_keylist.vkRight = tmp_right;
//		gx_keylist.vkDown = tmp_down;
	}
}
#endif

// ---- for menubase

BOOL scrnmng_entermenu(SCRNMENU *smenu) {

	VRAMHDL	vram;
#if defined(SUPPORT_SOFTKBD)
	CMNVRAM	kbdvram;
#endif

	if (smenu == NULL) {
		goto smem_err;
	}
	vram_destroy(scrnmng.vram);
#if defined(PPP_00)
	vram = vram_create(scrnmng.width /2, scrnmng.height, FALSE, 16);
#else
	vram = vram_create(scrnmng.width, scrnmng.height, FALSE, 16);
#endif
	scrnmng.vram = vram;
	if (vram == NULL) {
		goto smem_err;
	}
	scrndraw_redraw();
#if defined(SUPPORT_SOFTKBD)
	kbdvram.ptr = vram->ptr + (vram->yalign * scrnmng.kbdposy);
	kbdvram.width = vram->width;
	kbdvram.height = scrnmng.kbdheight;
	kbdvram.xalign = vram->xalign;
	kbdvram.yalign = vram->yalign;
	kbdvram.bpp = vram->bpp;
	softkbd_paint(&kbdvram, palcnv, TRUE);
#endif
#if defined(PPP_0)
//	smenu->width = scrnmng.width / 2 ;
	smenu->width = 320;
	smenu->height = 240;
#elif !defined(SIZE_VGA)
	smenu->width = scrnmng.width;
	smenu->height = scrnmng.height;
//	smenu->width = 320;
//	smenu->height = 240;
#else
	smenu->width = scrnmng.width;
	smenu->height = scrnmng.height;
#endif
	smenu->bpp = 16;
	return(SUCCESS);

smem_err:
	return(FAILURE);
}

void scrnmng_leavemenu(void) {

	VRAM_RELEASE(scrnmng.vram);
}

void scrnmng_menudraw(const RECT_T *rct) {

	DRAWRECT	dr;
const UINT8		*p;
const UINT8		*q;
	UINT8		*r;
	UINT8		*a;
	int			salign;
	int			dalign;
	int			x;

	if ((gx_disable) || (menuvram == NULL)) {
		return;
	}
	if (calcdrawrect(&dr, menuvram, rct) != SUCCESS) {
		return;
	}
	p = scrnmng.vram->ptr + (dr.srcpos * 2);
	q = menuvram->ptr + (dr.srcpos * 2);
	r = (UINT8 *)GXBEGINDRAW() + dr.dstpos;
	a = menuvram->alpha + dr.srcpos;
	salign = menuvram->width;
	dalign = dr.yalign - (dr.width * dr.xalign);
	do {
		x = 0;
		do {
			if (a[x]) {
				if (a[x] & 2) {
					*(UINT16 *)r = *(UINT16 *)(q + x * 2);
				}
				else {
					a[x] = 0;
					*(UINT16 *)r = *(UINT16 *)(p + x * 2);
				}
			}
			r += dr.xalign;
		} while(++x < dr.width);
		p += salign * 2;
		q += salign * 2;
		r += dalign;
		a += salign;
	} while(--dr.height);
//	GXENDDRAW();
#if defined(RESIZE)
			CXEndDraw();
#else
			GXENDDRAW();
#endif
}


// ----

#if defined(SUPPORT_SOFTKBD)
BOOL scrnmng_kbdpos(LPARAM *lp) {

	UINT	x;
	UINT	y;

	x = LOWORD(*lp);
	y = HIWORD(*lp) - scrnmng.kbdposy;
	*lp = (x & 0xffff) | ((y << 16) & 0xffff0000);
	return(SUCCESS);
}

BOOL scrnmng_ismenu(LPARAM lp) {

	if ((LOWORD(lp) < 32) && (HIWORD(lp) >= (scrnmng.height - 32))) {
		return(TRUE);
	}
	else {
		return(FALSE);
	}
}
#endif

